/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.RealmCallback;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.bind.model.Bind;
import rocks.xmpp.core.net.ChannelEncryption;
import rocks.xmpp.core.net.client.ClientConnectionConfiguration;
import rocks.xmpp.core.sasl.model.Mechanisms;
import rocks.xmpp.core.session.AuthenticationManager;
import rocks.xmpp.core.session.NoResponseException;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.XmppSessionConfiguration;
import rocks.xmpp.core.session.model.Session;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.Message;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.core.stanza.model.client.ClientIQ;
import rocks.xmpp.core.stanza.model.client.ClientMessage;
import rocks.xmpp.core.stanza.model.client.ClientPresence;
import rocks.xmpp.core.stream.StreamFeatureNegotiator;
import rocks.xmpp.core.stream.StreamNegotiationException;
import rocks.xmpp.core.stream.StreamNegotiationResult;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.core.stream.model.StreamFeature;
import rocks.xmpp.extensions.sm.client.ClientStreamManager;
import rocks.xmpp.im.roster.RosterManager;
import rocks.xmpp.im.subscription.PresenceManager;

public final class XmppClient
extends XmppSession {
    private static final System.Logger logger = System.getLogger(XmppClient.class.getName());
    private final AuthenticationManager authenticationManager = new AuthenticationManager(this);
    private volatile String resource;
    private volatile String lastAuthorizationId;
    private volatile Collection<String> lastMechanisms;
    private volatile CallbackHandler lastCallbackHandler;
    private volatile boolean anonymous;

    private XmppClient(String xmppServiceDomain, XmppSessionConfiguration configuration, ClientConnectionConfiguration ... connectionConfigurations) {
        super(xmppServiceDomain, configuration, connectionConfigurations);
        this.streamFeaturesManager.addFeatureNegotiator(this.authenticationManager);
        this.streamFeaturesManager.addFeatureNegotiator((StreamFeatureNegotiator<? extends StreamFeature>)((StreamFeatureNegotiator)element -> {
            if (element instanceof Bind) {
                return StreamNegotiationResult.INCOMPLETE;
            }
            return StreamNegotiationResult.IGNORE;
        }));
    }

    public static XmppClient create(String xmppServiceDomain, ClientConnectionConfiguration ... connectionConfigurations) {
        return XmppClient.create(xmppServiceDomain, XmppSessionConfiguration.getDefault(), connectionConfigurations);
    }

    public static XmppClient create(String xmppServiceDomain, XmppSessionConfiguration configuration, ClientConnectionConfiguration ... connectionConfigurations) {
        XmppClient xmppClient = new XmppClient(xmppServiceDomain, configuration, connectionConfigurations);
        XmppClient.notifyCreationListeners(xmppClient);
        return xmppClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void connect(Jid from) throws XmppException {
        XmppSession.Status previousStatus = this.preConnect();
        if (this.checkConnected()) {
            return;
        }
        try {
            this.updateStatus(XmppSession.Status.CONNECTING);
            XmppClient xmppClient = this;
            synchronized (xmppClient) {
                if (this.checkConnected()) {
                    return;
                }
                this.exception = null;
                this.tryConnect(from, "jabber:client", "1.0");
                logger.log(System.Logger.Level.DEBUG, "Negotiating stream, waiting until SASL is ready to be negotiated.");
                XmppClient.throwAsXmppExceptionIfNotNull(this.exception);
                try {
                    this.streamFeaturesManager.awaitNegotiation(Mechanisms.class).get(this.configuration.getDefaultResponseTimeout().toMillis(), TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    throw new NoResponseException("Timeout while waiting on advertised authentication mechanisms.");
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw e;
                }
                catch (CancellationException e) {
                    XmppClient.throwAsXmppExceptionIfNotNull(this.exception != null ? this.exception : e);
                }
                XmppClient.throwAsXmppExceptionIfNotNull(this.exception);
                logger.log(System.Logger.Level.DEBUG, "Stream negotiated until SASL, now ready to login.");
            }
            if (!this.activeConnection.isSecure() && this.activeConnection.getConfiguration().getChannelEncryption() == ChannelEncryption.REQUIRED) {
                throw new StreamNegotiationException("Transport Layer Security has been configured, but hasn't been negotiated.");
            }
            this.updateStatus(XmppSession.Status.CONNECTING, XmppSession.Status.CONNECTED);
            if (this.wasLoggedIn) {
                logger.log(System.Logger.Level.DEBUG, "Was already logged in. Re-login automatically with known credentials.");
                this.login(this.lastMechanisms, this.lastAuthorizationId, this.lastCallbackHandler, this.resource);
            }
        }
        catch (Throwable e) {
            this.onConnectionFailed(previousStatus, e);
        }
    }

    public final byte[] login(String user, String password) throws XmppException {
        return this.login(user, password, null);
    }

    public final byte[] login(String user, String password, String resource) throws XmppException {
        return this.login(null, user, password, resource);
    }

    public final byte[] login(String authorizationId, String user, String password, String resource) throws XmppException {
        Objects.requireNonNull(user, "user must not be null.");
        Objects.requireNonNull(password, "password must not be null.");
        return this.login(authorizationId, (Callback[] callbacks) -> Arrays.stream(callbacks).forEach(callback -> {
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(user);
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(password.toCharArray());
            }
            if (callback instanceof RealmCallback) {
                ((RealmCallback)callback).setText(((RealmCallback)callback).getDefaultText());
            }
        }), resource);
    }

    public final byte[] login(String authorizationId, CallbackHandler callbackHandler, String resource) throws XmppException {
        return this.login(this.configuration.getAuthenticationMechanisms(), authorizationId, callbackHandler, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] login(Collection<String> mechanisms, String authorizationId, CallbackHandler callbackHandler, String resource) throws XmppException {
        if (this.checkAuthenticated()) {
            return this.authenticationManager.getSuccessData();
        }
        XmppSession.Status previousStatus = this.preLogin();
        this.updateStatus(XmppSession.Status.AUTHENTICATING);
        XmppClient xmppClient = this;
        synchronized (xmppClient) {
            if (this.checkAuthenticated()) {
                return this.authenticationManager.getSuccessData();
            }
            this.lastMechanisms = mechanisms;
            this.lastAuthorizationId = authorizationId;
            this.lastCallbackHandler = callbackHandler;
            try {
                Presence initialPresence;
                PresenceManager presenceManager;
                long timeout = this.configuration.getDefaultResponseTimeout().toMillis();
                logger.log(System.Logger.Level.DEBUG, "Starting SASL negotiation (authentication).");
                if (callbackHandler == null) {
                    this.authenticationManager.startAuthentication(mechanisms, null, null);
                } else {
                    this.authenticationManager.startAuthentication(mechanisms, authorizationId, callbackHandler);
                }
                try {
                    this.streamFeaturesManager.awaitNegotiation(Bind.class).get(timeout, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    throw new NoResponseException("Timeout while waiting on resource binding feature.");
                }
                XmppClient.throwAsXmppExceptionIfNotNull(this.exception);
                try {
                    ClientStreamManager streamManager = this.getManager(ClientStreamManager.class);
                    if (((Boolean)streamManager.resume().getResult(timeout, TimeUnit.MILLISECONDS)).booleanValue()) {
                        logger.log(System.Logger.Level.DEBUG, "Stream resumed.");
                        this.updateStatus(XmppSession.Status.AUTHENTICATED);
                        this.afterLogin();
                        return this.authenticationManager.getSuccessData();
                    }
                }
                catch (TimeoutException e) {
                    logger.log(System.Logger.Level.WARNING, "Could not resume stream due to timeout.");
                }
                this.bindResource(resource);
                try {
                    this.streamFeaturesManager.completeNegotiation().get(timeout * 2L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    throw new NoResponseException("Timeout while waiting on stream feature negotiation to finish.");
                }
                XmppClient.throwAsXmppExceptionIfNotNull(this.exception);
                logger.log(System.Logger.Level.DEBUG, "Stream negotiation completed successfully.");
                RosterManager rosterManager = this.getManager(RosterManager.class);
                if (callbackHandler != null && rosterManager.isRetrieveRosterOnLogin()) {
                    logger.log(System.Logger.Level.DEBUG, "Retrieving roster on login (as per configuration).");
                    try {
                        rosterManager.requestRoster().getResult(timeout, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException e) {
                        logger.log(System.Logger.Level.WARNING, "Could not retrieve roster in time.");
                    }
                }
                if ((presenceManager = this.getManager(PresenceManager.class)).getLastSentPresence() != null) {
                    presenceManager.getLastSentPresences().forEach(presence -> {
                        presence.getExtensions().clear();
                        this.send((StreamElement)presence, false);
                    });
                } else if (this.configuration.getInitialPresence() != null && (initialPresence = this.configuration.getInitialPresence().get()) != null) {
                    this.send((StreamElement)initialPresence, false);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.updateStatus(previousStatus, e);
                XmppClient.throwAsXmppExceptionIfNotNull(e);
            }
            catch (CancellationException e) {
                Throwable cause = this.exception != null ? this.exception : e;
                this.updateStatus(previousStatus, cause);
                XmppClient.throwAsXmppExceptionIfNotNull(cause);
            }
            catch (Throwable e) {
                this.updateStatus(previousStatus, e);
                XmppClient.throwAsXmppExceptionIfNotNull(e);
            }
            logger.log(System.Logger.Level.DEBUG, "Login successful.");
            this.afterLogin();
            return this.authenticationManager.getSuccessData();
        }
    }

    public final byte[] loginAnonymously() throws XmppException {
        byte[] successData = this.login(Collections.singleton("ANONYMOUS"), null, null, null);
        this.anonymous = true;
        return successData;
    }

    private void bindResource(String resource) throws XmppException {
        IQ result;
        this.resource = resource;
        logger.log(System.Logger.Level.DEBUG, "Negotiating resource binding, resource: {0}.", resource);
        try {
            result = (IQ)this.query(IQ.set((Object)new Bind(this.resource))).getResult(this.configuration.getDefaultResponseTimeout().toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new NoResponseException("Could not bind resource due to timeout.");
        }
        Bind bindResult = (Bind)result.getExtension(Bind.class);
        this.connectedResource = bindResult.getJid();
        logger.log(System.Logger.Level.DEBUG, "Resource binding completed, connected resource: {0}.", this.connectedResource);
        Session session = (Session)this.streamFeaturesManager.getFeatures().get(Session.class);
        if (session != null && session.isMandatory()) {
            logger.log(System.Logger.Level.DEBUG, "Establishing session.");
            this.query(IQ.set((Object)new Session()));
        }
        this.updateStatus(XmppSession.Status.AUTHENTICATED);
    }

    public final boolean isAnonymous() {
        return this.anonymous;
    }

    @Override
    protected final StreamElement prepareElement(StreamElement element) {
        if (element instanceof Message) {
            element = ClientMessage.from((Message)((Message)element));
        } else if (element instanceof Presence) {
            element = ClientPresence.from((Presence)((Presence)element));
        } else if (element instanceof IQ) {
            element = ClientIQ.from((IQ)((IQ)element));
        }
        return element;
    }
}

