/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.caps.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.stream.XMLStreamWriter;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.extensions.caps.EntityCapabilitiesManager;
import rocks.xmpp.extensions.disco.ServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.DiscoverableInfo;
import rocks.xmpp.extensions.hashes.model.Hash;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.cache.DirectoryCache;
import rocks.xmpp.util.cache.LruCache;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class ClientEntityCapabilitiesManager
implements EntityCapabilitiesManager {
    private static final System.Logger logger = System.getLogger(ClientEntityCapabilitiesManager.class.getName());
    private static final Map<Hash, DiscoverableInfo> CAPS_CACHE = new LruCache(100);
    private static final Map<Jid, DiscoverableInfo> ENTITY_CAPABILITIES = new ConcurrentHashMap<Jid, DiscoverableInfo>();
    private static final Map<Jid, AsyncResult<DiscoverableInfo>> REQUESTS = new ConcurrentHashMap<Jid, AsyncResult<DiscoverableInfo>>();
    private final DirectoryCache directoryCache;
    private final XmppSession xmppSession;

    public ClientEntityCapabilitiesManager(XmppSession xmppSession) {
        this.xmppSession = xmppSession;
        this.directoryCache = xmppSession.getConfiguration().getCacheDirectory() != null ? new DirectoryCache(xmppSession.getConfiguration().getCacheDirectory().resolve("caps")) : null;
    }

    public DiscoverableInfo readCapabilities(Hash hash) {
        block9: {
            if (this.directoryCache != null) {
                DiscoverableInfo discoverableInfo;
                DiscoverableInfo discoverableInfo2 = CAPS_CACHE.get(hash);
                if (discoverableInfo2 != null) {
                    return discoverableInfo2;
                }
                String fileName = XmppUtils.hash((byte[])hash.toString().getBytes(StandardCharsets.UTF_8)) + ".caps";
                byte[] bytes = this.directoryCache.get((Object)fileName);
                if (bytes == null) break block9;
                InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), StandardCharsets.UTF_8);
                try {
                    discoverableInfo2 = (DiscoverableInfo)this.xmppSession.createUnmarshaller().unmarshal((Reader)reader);
                    CAPS_CACHE.put(hash, discoverableInfo2);
                    discoverableInfo = discoverableInfo2;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        logger.log(System.Logger.Level.WARNING, () -> "Could not read entity capabilities from persistent cache (file: " + fileName + ")", (Throwable)e);
                    }
                }
                ((Reader)reader).close();
                return discoverableInfo;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCapabilities(Hash hash, DiscoverableInfo discoverableInfo) {
        if (this.directoryCache != null) {
            CAPS_CACHE.put(hash, discoverableInfo);
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                try (XMLStreamWriter xmppStreamWriter = null;){
                    xmppStreamWriter = XmppUtils.createXmppStreamWriter((XMLStreamWriter)this.xmppSession.getConfiguration().getXmlOutputFactory().createXMLStreamWriter(byteArrayOutputStream, StandardCharsets.UTF_8.name()));
                    this.xmppSession.createMarshaller().marshal((Object)discoverableInfo, xmppStreamWriter);
                    xmppStreamWriter.flush();
                }
                this.directoryCache.put(XmppUtils.hash((byte[])hash.toString().getBytes(StandardCharsets.UTF_8)) + ".caps", byteArrayOutputStream.toByteArray());
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.WARNING, () -> "Could not write entity capabilities to persistent cache. Reason: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public DiscoverableInfo readEntityCapabilities(Jid entity) {
        return ENTITY_CAPABILITIES.get(entity);
    }

    public void writeEntityCapabilities(Jid entity, DiscoverableInfo discoverableInfo) {
        ENTITY_CAPABILITIES.put(entity, discoverableInfo);
    }

    public final AsyncResult<DiscoverableInfo> discoverCapabilities(Jid jid) {
        DiscoverableInfo discoverableInfo = this.readEntityCapabilities(jid);
        if (discoverableInfo == null) {
            return REQUESTS.computeIfAbsent(jid, key -> this.xmppSession.getManager(ServiceDiscoveryManager.class).discoverInformation(jid).whenComplete((result, e) -> {
                if (result != null) {
                    this.writeEntityCapabilities(jid, (DiscoverableInfo)result);
                }
                REQUESTS.remove(jid);
            }));
        }
        return new AsyncResult(CompletableFuture.completedFuture(discoverableInfo));
    }
}

