/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.net.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.net.ChannelEncryption;
import rocks.xmpp.core.net.Connection;
import rocks.xmpp.core.net.TcpConnection;
import rocks.xmpp.core.net.client.TcpConnectionConfiguration;
import rocks.xmpp.core.net.client.TransportConnector;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.model.SessionOpen;
import rocks.xmpp.dns.DnsResolver;
import rocks.xmpp.dns.SrvRecord;
import rocks.xmpp.util.concurrent.CompletionStages;

public abstract class AbstractTcpConnector<T>
implements TransportConnector<TcpConnectionConfiguration> {
    private static final System.Logger logger = System.getLogger(AbstractTcpConnector.class.getName());

    protected final CompletableFuture<Connection> createConnection(XmppSession xmppSession, TcpConnectionConfiguration configuration, BiFunction<T, TcpConnectionConfiguration, TcpConnection> creator, SessionOpen sessionOpen) {
        CompletableFuture<T> socket;
        AtomicBoolean useDirectTls = new AtomicBoolean(configuration.getChannelEncryption() == ChannelEncryption.DIRECT);
        if (configuration.getHostname() != null && !configuration.getHostname().isEmpty()) {
            socket = this.connect(configuration.getHostname(), configuration.getPort(), configuration);
        } else if (xmppSession.getDomain() != null) {
            socket = this.connectWithXmppServiceDomain(xmppSession.getDomain(), configuration, xmppSession.getConfiguration().getNameServer(), useDirectTls::set);
            if (socket == null) {
                socket = this.connect(xmppSession.getDomain().toString(), configuration.getPort(), configuration);
            }
        } else {
            throw new IllegalStateException("Neither 'xmppServiceDomain' nor 'host' is set.");
        }
        return ((CompletableFuture)socket.thenApply(s -> {
            TcpConnection tcpConnection = (TcpConnection)creator.apply(s, configuration);
            if (useDirectTls.get()) {
                try {
                    tcpConnection.secureConnection();
                }
                catch (Exception e) {
                    throw new CompletionException(e);
                }
            }
            return tcpConnection;
        })).thenCompose(connection -> connection.open(sessionOpen).thenApply(aVoid -> connection));
    }

    protected abstract CompletableFuture<T> connect(String var1, int var2, TcpConnectionConfiguration var3);

    CompletableFuture<T> connectWithXmppServiceDomain(Jid xmppServiceDomain, TcpConnectionConfiguration configuration, String nameServer, Consumer<Boolean> isDirectTls) {
        try {
            ArrayList<SrvRecord> srvRecords = new ArrayList<SrvRecord>();
            if (configuration.getChannelEncryption() != ChannelEncryption.DIRECT) {
                srvRecords.addAll(DnsResolver.resolveSRV("xmpp-client", (CharSequence)xmppServiceDomain, nameServer, configuration.getConnectTimeout()));
            }
            ArrayList<SrvRecord> srvRecordsXmpps = new ArrayList<SrvRecord>();
            if (configuration.getChannelEncryption() != ChannelEncryption.DISABLED) {
                srvRecordsXmpps.addAll(DnsResolver.resolveSRV("xmpps-client", (CharSequence)xmppServiceDomain, nameServer, configuration.getConnectTimeout()));
            }
            srvRecords.addAll(srvRecordsXmpps);
            srvRecords.sort(null);
            if (!srvRecords.isEmpty()) {
                return this.connectToNextHost(srvRecords.iterator(), srvRecordsXmpps, configuration, isDirectTls);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private CompletableFuture<T> connectToNextHost(Iterator<SrvRecord> iterator, List<SrvRecord> srvRecordsXmpps, TcpConnectionConfiguration configuration, Consumer<Boolean> isDirectTls) {
        if (iterator.hasNext()) {
            SrvRecord srvRecord = iterator.next();
            if (".".equals(srvRecord.getTarget())) {
                if (srvRecordsXmpps.contains(srvRecord)) {
                    return this.connectToNextHost(iterator, srvRecordsXmpps, configuration, isDirectTls);
                }
                return null;
            }
            logger.log(System.Logger.Level.DEBUG, "Trying to connect to {0}:{1}", srvRecord.getTarget(), String.valueOf(srvRecord.getPort()));
            CompletableFuture<T> socket = this.connect(srvRecord.getTarget(), srvRecord.getPort(), configuration);
            return CompletionStages.withFallback(socket, (failedStage, exc) -> this.connectToNextHost(iterator, srvRecordsXmpps, configuration, isDirectTls)).thenApply(s -> {
                if (srvRecordsXmpps.contains(srvRecord)) {
                    isDirectTls.accept(true);
                }
                return s;
            }).toCompletableFuture();
        }
        return CompletableFuture.failedFuture(new IOException("Could not connect to any host"));
    }
}

