/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.net.client;

import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import rocks.xmpp.core.Session;
import rocks.xmpp.core.net.Connection;
import rocks.xmpp.core.net.ReaderInterceptor;
import rocks.xmpp.core.net.ReaderInterceptorChain;
import rocks.xmpp.core.net.client.SocketConnection;
import rocks.xmpp.core.net.client.XmppStreamWriter;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.core.stream.model.StreamError;
import rocks.xmpp.core.stream.model.StreamErrorException;
import rocks.xmpp.core.stream.model.StreamHeader;
import rocks.xmpp.core.stream.model.errors.Condition;
import rocks.xmpp.util.XmppStreamDecoder;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.concurrent.QueuedExecutorService;

final class XmppStreamReader {
    private static final System.Logger logger = System.getLogger(XmppStreamWriter.class.getName());
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newCachedThreadPool(XmppUtils.createNamedThreadFactory((String)"Reader Thread"));
    private final SocketConnection connection;
    private final XmppSession xmppSession;
    private final ExecutorService executorService;
    private final List<ReaderInterceptor> readerInterceptors = new ArrayList<ReaderInterceptor>();
    private final XmppStreamDecoder xmppStreamDecoder;

    XmppStreamReader(Iterable<ReaderInterceptor> readerInterceptors, String namespace, SocketConnection connection, XmppSession xmppSession) {
        this.connection = connection;
        this.xmppSession = xmppSession;
        this.executorService = new QueuedExecutorService((Executor)EXECUTOR_SERVICE);
        this.xmppStreamDecoder = new XmppStreamDecoder(xmppSession.getConfiguration().getXmlInputFactory(), xmppSession::createUnmarshaller, namespace);
        readerInterceptors.forEach(this.readerInterceptors::add);
        this.readerInterceptors.add((ReaderInterceptor)this.xmppStreamDecoder);
    }

    void startReading() {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        ReaderInterceptorChain context = new ReaderInterceptorChain(XmppStreamReader.this.readerInterceptors, (Session)XmppStreamReader.this.xmppSession, (Connection)XmppStreamReader.this.connection);
                        context.proceed((Reader)new InputStreamReader(XmppStreamReader.this.connection.getInputStream(), StandardCharsets.UTF_8), streamElement -> XmppStreamReader.this.handle((StreamElement)streamElement, this));
                    }
                    catch (Exception e) {
                        XmppStreamReader.this.executorService.shutdown();
                        if (XmppStreamReader.this.connection.isClosed()) break block2;
                        XmppStreamReader.this.xmppSession.notifyException(e);
                    }
                }
            }
        });
    }

    private void handle(StreamElement streamElement, Runnable reader) {
        boolean wasClosed = this.connection.isClosed();
        if (this.connection.handleElement(streamElement)) {
            this.xmppStreamDecoder.restart();
            reader.run();
        }
        if (streamElement == StreamHeader.CLOSING_STREAM_TAG && !wasClosed) {
            if (logger.isLoggable(System.Logger.Level.DEBUG)) {
                logger.log(System.Logger.Level.DEBUG, "Stream closed by server");
            }
            this.xmppSession.notifyException((Throwable)new StreamErrorException(new StreamError(Condition.UNDEFINED_CONDITION, "Stream closed by server", Locale.ENGLISH, null)));
        }
    }

    void shutdown() {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

