/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import rocks.xmpp.core.ExtensionProtocol;
import rocks.xmpp.core.session.Manager;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.IQEvent;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.InboundIQHandler;
import rocks.xmpp.core.stanza.InboundMessageHandler;
import rocks.xmpp.core.stanza.InboundPresenceHandler;
import rocks.xmpp.core.stanza.MessageEvent;
import rocks.xmpp.core.stanza.OutboundIQHandler;
import rocks.xmpp.core.stanza.OutboundMessageHandler;
import rocks.xmpp.core.stanza.OutboundPresenceHandler;
import rocks.xmpp.core.stanza.PresenceEvent;
import rocks.xmpp.core.stream.StreamFeatureNegotiator;
import rocks.xmpp.core.stream.client.StreamFeaturesManager;
import rocks.xmpp.core.stream.model.StreamFeature;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.model.info.DiscoverableInfo;
import rocks.xmpp.extensions.disco.model.info.Identity;

final class ExtensionProtocolRegistry
implements DiscoverableInfo {
    private final Map<String, ExtensionProtocol> extensionProtocolMap = new HashMap<String, ExtensionProtocol>();
    private final Set<ExtensionProtocol> enabledExtensions = new HashSet<ExtensionProtocol>();
    private final Map<OutboundPresenceHandler, Consumer<PresenceEvent>> outboundPresenceHandlerConsumerMap = new HashMap<OutboundPresenceHandler, Consumer<PresenceEvent>>();
    private final Map<OutboundMessageHandler, Consumer<MessageEvent>> outboundMessageHandlerConsumerMap = new HashMap<OutboundMessageHandler, Consumer<MessageEvent>>();
    private final Map<OutboundIQHandler, Consumer<IQEvent>> outboundIQeHandlerConsumerMap = new HashMap<OutboundIQHandler, Consumer<IQEvent>>();
    private final Map<InboundPresenceHandler, Consumer<PresenceEvent>> inboundPresenceHandlerConsumerMap = new HashMap<InboundPresenceHandler, Consumer<PresenceEvent>>();
    private final Map<InboundMessageHandler, Consumer<MessageEvent>> inboundMessageHandlerConsumerMap = new HashMap<InboundMessageHandler, Consumer<MessageEvent>>();
    private final Map<InboundIQHandler, Consumer<IQEvent>> inboundIQHandlerConsumerMap = new HashMap<InboundIQHandler, Consumer<IQEvent>>();
    private final XmppSession xmppSession;

    private ExtensionProtocolRegistry(XmppSession xmppSession) {
        this.xmppSession = xmppSession;
    }

    synchronized void registerExtension(ExtensionProtocol extensionProtocol) {
        this.extensionProtocolMap.put(extensionProtocol.getNamespace(), extensionProtocol);
        if (extensionProtocol instanceof InboundMessageHandler) {
            this.inboundMessageHandlerConsumerMap.put((InboundMessageHandler)extensionProtocol, arg_0 -> ((InboundMessageHandler)((InboundMessageHandler)extensionProtocol)).handleInboundMessage(arg_0));
        }
        if (extensionProtocol instanceof OutboundMessageHandler) {
            this.outboundMessageHandlerConsumerMap.put((OutboundMessageHandler)extensionProtocol, arg_0 -> ((OutboundMessageHandler)((OutboundMessageHandler)extensionProtocol)).handleOutboundMessage(arg_0));
        }
        if (extensionProtocol instanceof InboundPresenceHandler) {
            this.inboundPresenceHandlerConsumerMap.put((InboundPresenceHandler)extensionProtocol, arg_0 -> ((InboundPresenceHandler)((InboundPresenceHandler)extensionProtocol)).handleInboundPresence(arg_0));
        }
        if (extensionProtocol instanceof OutboundPresenceHandler) {
            this.outboundPresenceHandlerConsumerMap.put((OutboundPresenceHandler)extensionProtocol, arg_0 -> ((OutboundPresenceHandler)((OutboundPresenceHandler)extensionProtocol)).handleOutboundPresence(arg_0));
        }
        if (extensionProtocol instanceof InboundIQHandler) {
            this.inboundIQHandlerConsumerMap.put((InboundIQHandler)extensionProtocol, arg_0 -> ((InboundIQHandler)((InboundIQHandler)extensionProtocol)).handleInboundIQ(arg_0));
        }
        if (extensionProtocol instanceof OutboundIQHandler) {
            this.outboundIQeHandlerConsumerMap.put((OutboundIQHandler)extensionProtocol, arg_0 -> ((OutboundIQHandler)((OutboundIQHandler)extensionProtocol)).handleOutboundIQ(arg_0));
        }
        if (extensionProtocol.isEnabled()) {
            this.enableExtension(extensionProtocol.getNamespace());
        }
    }

    synchronized void enableExtension(String namespace) {
        ExtensionProtocol extensionProtocol = this.extensionProtocolMap.get(namespace);
        if (extensionProtocol != null) {
            this.enabledExtensions.add(extensionProtocol);
            if (!extensionProtocol.isEnabled() && extensionProtocol instanceof Manager) {
                ((Manager)extensionProtocol).setEnabled(true);
            }
            if (extensionProtocol instanceof IQHandler) {
                this.xmppSession.addIQHandler((IQHandler)extensionProtocol);
            }
            if (extensionProtocol instanceof InboundMessageHandler) {
                this.xmppSession.addInboundMessageListener(this.inboundMessageHandlerConsumerMap.get(extensionProtocol));
            }
            if (extensionProtocol instanceof OutboundMessageHandler) {
                this.xmppSession.addOutboundMessageListener(this.outboundMessageHandlerConsumerMap.get(extensionProtocol));
            }
            if (extensionProtocol instanceof InboundPresenceHandler) {
                this.xmppSession.addInboundPresenceListener(this.inboundPresenceHandlerConsumerMap.get(extensionProtocol));
            }
            if (extensionProtocol instanceof OutboundPresenceHandler) {
                this.xmppSession.addOutboundPresenceListener(this.outboundPresenceHandlerConsumerMap.get(extensionProtocol));
            }
            if (extensionProtocol instanceof InboundIQHandler) {
                this.xmppSession.addInboundIQListener(this.inboundIQHandlerConsumerMap.get(extensionProtocol));
            }
            if (extensionProtocol instanceof OutboundIQHandler) {
                this.xmppSession.addOutboundIQListener(this.outboundIQeHandlerConsumerMap.get(extensionProtocol));
            }
            if (extensionProtocol instanceof StreamFeatureNegotiator) {
                this.xmppSession.getManager(StreamFeaturesManager.class).addFeatureNegotiator((StreamFeatureNegotiator<? extends StreamFeature>)((StreamFeatureNegotiator)extensionProtocol));
            }
        }
    }

    synchronized void enableExtension(Class<?> clazz) {
        for (ExtensionProtocol extensionProtocol : this.extensionProtocolMap.values()) {
            if (extensionProtocol.getClass() != clazz) continue;
            this.enableExtension(extensionProtocol.getNamespace());
            return;
        }
    }

    synchronized void disableExtension(String namespace) {
        ExtensionProtocol extensionProtocol = this.extensionProtocolMap.get(namespace);
        if (extensionProtocol != null) {
            this.enabledExtensions.remove(extensionProtocol);
            if (extensionProtocol.isEnabled() && extensionProtocol instanceof Manager) {
                ((Manager)extensionProtocol).setEnabled(false);
            }
            if (extensionProtocol instanceof IQHandler) {
                this.xmppSession.removeIQHandler((IQHandler)extensionProtocol);
            }
            if (extensionProtocol instanceof InboundMessageHandler) {
                this.xmppSession.removeInboundMessageListener(this.inboundMessageHandlerConsumerMap.get(extensionProtocol));
            }
            if (extensionProtocol instanceof OutboundMessageHandler) {
                this.xmppSession.removeOutboundMessageListener(this.outboundMessageHandlerConsumerMap.get(extensionProtocol));
            }
            if (extensionProtocol instanceof InboundPresenceHandler) {
                this.xmppSession.removeInboundPresenceListener(this.inboundPresenceHandlerConsumerMap.get(extensionProtocol));
            }
            if (extensionProtocol instanceof OutboundPresenceHandler) {
                this.xmppSession.removeOutboundPresenceListener(this.outboundPresenceHandlerConsumerMap.get(extensionProtocol));
            }
            if (extensionProtocol instanceof InboundIQHandler) {
                this.xmppSession.removeInboundIQListener(this.inboundIQHandlerConsumerMap.get(extensionProtocol));
            }
            if (extensionProtocol instanceof OutboundIQHandler) {
                this.xmppSession.removeOutboundIQListener(this.outboundIQeHandlerConsumerMap.get(extensionProtocol));
            }
            if (extensionProtocol instanceof StreamFeatureNegotiator) {
                this.xmppSession.getManager(StreamFeaturesManager.class).removeFeatureNegotiator((StreamFeatureNegotiator<? extends StreamFeature>)((StreamFeatureNegotiator)extensionProtocol));
            }
        }
    }

    synchronized void disableExtension(Class<?> clazz) {
        for (ExtensionProtocol extensionProtocol : this.extensionProtocolMap.values()) {
            if (extensionProtocol.getClass() != clazz) continue;
            this.disableExtension(extensionProtocol.getNamespace());
            return;
        }
    }

    public final Set<Identity> getIdentities() {
        return this.enabledExtensions.stream().filter(e -> e instanceof DiscoverableInfo).flatMap(extension -> ((DiscoverableInfo)extension).getIdentities().stream()).collect(Collectors.toSet());
    }

    public final Set<String> getFeatures() {
        return this.enabledExtensions.stream().filter(e -> e instanceof DiscoverableInfo).flatMap(extension -> ((DiscoverableInfo)extension).getFeatures().stream()).collect(Collectors.toSet());
    }

    public final List<DataForm> getExtensions() {
        return this.enabledExtensions.stream().filter(e -> e instanceof DiscoverableInfo).flatMap(extension -> ((DiscoverableInfo)extension).getExtensions().stream()).collect(Collectors.toList());
    }
}

