/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session;

import rocks.xmpp.core.session.XmppSession;

public class Manager {
    protected final XmppSession xmppSession;
    private volatile boolean enabled;

    public Manager(XmppSession xmppSession) {
        this(xmppSession, false);
    }

    public Manager(XmppSession xmppSession, boolean disposable) {
        this.xmppSession = xmppSession;
        if (disposable) {
            xmppSession.addSessionStatusListener(e -> {
                if (e.getStatus() == XmppSession.Status.CLOSING) {
                    this.dispose();
                }
            });
        }
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean enabled) {
        boolean wasEnabled = this.enabled;
        this.enabled = enabled;
        if (enabled && !wasEnabled) {
            this.onEnable();
        } else if (!enabled && wasEnabled) {
            this.onDisable();
        }
    }

    protected void onEnable() {
        this.xmppSession.enableFeature(this.getClass());
    }

    protected void onDisable() {
        this.xmppSession.disableFeature(this.getClass());
    }

    protected void initialize() {
    }

    protected void dispose() {
    }
}

