/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.session.debug;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.function.Consumer;
import rocks.xmpp.core.net.ReaderInterceptor;
import rocks.xmpp.core.net.ReaderInterceptorChain;
import rocks.xmpp.core.net.WriterInterceptor;
import rocks.xmpp.core.net.WriterInterceptorChain;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.util.XmppUtils;

public interface XmppDebugger
extends ReaderInterceptor,
WriterInterceptor {
    public void initialize(XmppSession var1);

    public void writeStanza(String var1, Object var2);

    public void readStanza(String var1, Object var2);

    public OutputStream createOutputStream(OutputStream var1);

    public InputStream createInputStream(InputStream var1);

    default public void process(StreamElement streamElement, Writer writer, WriterInterceptorChain chain) throws Exception {
        try (StringWriter logger = new StringWriter();){
            chain.proceed(streamElement, XmppUtils.newBranchedWriter((Writer)writer, (Writer)logger));
            this.writeStanza(((Object)logger).toString(), streamElement);
        }
    }

    default public void process(Reader reader, Consumer<StreamElement> streamElement, ReaderInterceptorChain chain) throws Exception {
        try (StringWriter logger = new StringWriter();){
            chain.proceed(XmppUtils.newBranchedReader((Reader)reader, (Writer)logger), element -> {
                String s = logger.toString();
                if (!s.isEmpty()) {
                    this.readStanza(logger.toString(), element);
                    logger.getBuffer().setLength(0);
                }
                streamElement.accept((StreamElement)element);
            });
        }
    }
}

