/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.dns;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import rocks.xmpp.dns.Question;
import rocks.xmpp.dns.ResourceRecord;

final class Message {
    final short id;
    private final boolean query;
    private final OpCode opCode;
    private final boolean authoritativeAnswer;
    private final boolean truncation;
    private final boolean recursionDesired;
    private final boolean recursionAvailable;
    final ResponseCode responseCode;
    private final short questionCount;
    private final short answerCount;
    private final short nameServerCount;
    private final short additionalRecordsCount;
    private final List<Question> questions = new ArrayList<Question>();
    private final List<ResourceRecord> answers = new ArrayList<ResourceRecord>();
    private final List<ResourceRecord> nameServers = new ArrayList<ResourceRecord>();

    Message(ByteBuffer data) {
        short i;
        this.id = data.getShort();
        short header = data.getShort();
        this.query = (header >> 15 & 1) == 0;
        this.opCode = OpCode.values()[header >> 11 & 0xF];
        this.authoritativeAnswer = (header >> 10 & 1) == 1;
        this.truncation = (header >> 9 & 1) == 1;
        this.recursionDesired = (header >> 8 & 1) == 1;
        this.recursionAvailable = (header >> 7 & 1) == 1;
        this.responseCode = ResponseCode.values()[header & 0xF];
        this.questionCount = data.getShort();
        this.answerCount = data.getShort();
        this.nameServerCount = data.getShort();
        this.additionalRecordsCount = data.getShort();
        for (i = 0; i < this.questionCount; i = (short)(i + 1)) {
            this.questions.add(new Question(data));
        }
        for (i = 0; i < this.answerCount; i = (short)(i + 1)) {
            this.answers.add(new ResourceRecord(data));
        }
        for (i = 0; i < this.nameServerCount; i = (short)(i + 1)) {
            this.nameServers.add(new ResourceRecord(data));
        }
    }

    Message(Question ... question) {
        this.questions.addAll(Arrays.asList(question));
        this.id = (short)(ThreadLocalRandom.current().nextInt(65536) - 32768);
        this.query = true;
        this.opCode = OpCode.STANDARD_QUERY;
        this.authoritativeAnswer = false;
        this.truncation = false;
        this.recursionDesired = true;
        this.recursionAvailable = false;
        this.responseCode = ResponseCode.OK;
        this.questionCount = (short)question.length;
        this.answerCount = 0;
        this.nameServerCount = 0;
        this.additionalRecordsCount = 0;
    }

    final byte[] toByteArray() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(12);
        byteBuffer.putShort(this.id);
        short header = 0;
        header = (short)(header | (this.query ? 0 : 1) << 15);
        header = (short)(header | this.opCode.ordinal() << 11);
        header = (short)(header | (this.authoritativeAnswer ? 1 : 0) << 10);
        header = (short)(header | (this.truncation ? 1 : 0) << 9);
        header = (short)(header | (this.recursionDesired ? 1 : 0) << 8);
        header = (short)(header | (this.recursionAvailable ? 1 : 0) << 7);
        header = (short)(header | this.responseCode.ordinal());
        byteBuffer.putShort(header);
        byteBuffer.putShort(this.questionCount);
        byteBuffer.putShort(this.answerCount);
        byteBuffer.putShort(this.nameServerCount);
        byteBuffer.putShort(this.additionalRecordsCount);
        byte[] array = byteBuffer.array();
        for (int i = 0; i < this.questionCount; ++i) {
            array = Message.concatArrays(array, this.questions.get(i).toByteArray());
        }
        return array;
    }

    static byte[] concatArrays(byte[] first, byte[] second) {
        byte[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public final List<Question> getQuestions() {
        return Collections.unmodifiableList(this.questions);
    }

    public final List<ResourceRecord> getAnswers() {
        return Collections.unmodifiableList(this.answers);
    }

    public final List<ResourceRecord> getNameServers() {
        return Collections.unmodifiableList(this.nameServers);
    }

    public final List<ResourceRecord> getAdditionalRecords() {
        return Collections.emptyList();
    }

    static enum ResponseCode {
        OK,
        FORMAT_ERROR,
        SERVER_FAILURE,
        NAME_ERROR,
        NOT_IMPLEMENTED,
        REFUSED;

    }

    static enum OpCode {
        STANDARD_QUERY,
        INVERSE_QUERY,
        SERVER_STATUS_REQUEST;

    }
}

