/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.compress;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import rocks.xmpp.core.Session;
import rocks.xmpp.core.net.TcpConnection;
import rocks.xmpp.core.stream.StreamFeatureNegotiator;
import rocks.xmpp.core.stream.StreamNegotiationException;
import rocks.xmpp.core.stream.StreamNegotiationResult;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.extensions.compress.CompressionMethod;
import rocks.xmpp.extensions.compress.model.StreamCompression;
import rocks.xmpp.extensions.compress.model.feature.CompressionFeature;

public final class CompressionManager
implements StreamFeatureNegotiator<CompressionFeature> {
    private static final System.Logger logger = System.getLogger(CompressionManager.class.getName());
    private final TcpConnection tcpConnection;
    private final List<CompressionMethod> compressionMethods = new CopyOnWriteArrayList<CompressionMethod>();
    private final Session session;
    private CompressionMethod negotiatedCompressionMethod;

    public CompressionManager(Session session, TcpConnection tcpConnection) {
        this.session = session;
        this.tcpConnection = tcpConnection;
    }

    public final StreamNegotiationResult processNegotiation(Object element) throws StreamNegotiationException {
        if (this.compressionMethods.isEmpty()) {
            return StreamNegotiationResult.IGNORE;
        }
        if (element instanceof CompressionFeature) {
            List advertisedCompressionMethods = ((CompressionFeature)element).getMethods();
            LinkedHashMap<String, CompressionMethod> clientMethods = new LinkedHashMap<String, CompressionMethod>();
            for (CompressionMethod compressionMethod : this.compressionMethods) {
                clientMethods.put(compressionMethod.getName(), compressionMethod);
            }
            clientMethods.keySet().retainAll(advertisedCompressionMethods);
            if (!clientMethods.isEmpty()) {
                CompressionMethod compressionMethod = (CompressionMethod)clientMethods.values().iterator().next();
                this.session.send((StreamElement)new StreamCompression.Compress(compressionMethod.getName()));
                this.negotiatedCompressionMethod = compressionMethod;
                return StreamNegotiationResult.INCOMPLETE;
            }
            return StreamNegotiationResult.IGNORE;
        }
        if (element == StreamCompression.COMPRESSED) {
            try {
                this.tcpConnection.compressConnection(this.negotiatedCompressionMethod.getName(), null);
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.WARNING, "Failure during stream compression.", (Throwable)e);
                return StreamNegotiationResult.IGNORE;
            }
            logger.log(System.Logger.Level.DEBUG, "Stream is now compressed.");
            return StreamNegotiationResult.RESTART;
        }
        if (element instanceof StreamCompression.Failure) {
            this.negotiatedCompressionMethod = null;
            logger.log(System.Logger.Level.WARNING, "Failure during compression negotiation: " + ((StreamCompression.Failure)element).getCondition());
            return StreamNegotiationResult.IGNORE;
        }
        return StreamNegotiationResult.IGNORE;
    }

    public final CompressionMethod getNegotiatedCompressionMethod() {
        return this.negotiatedCompressionMethod;
    }

    public final List<CompressionMethod> getConfiguredCompressionMethods() {
        return this.compressionMethods;
    }
}

