/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.disco.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.AbstractServiceDiscoveryManager;
import rocks.xmpp.extensions.disco.model.info.DiscoverableInfo;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.disco.model.info.InfoDiscovery;
import rocks.xmpp.extensions.disco.model.items.ItemDiscovery;
import rocks.xmpp.extensions.disco.model.items.ItemNode;
import rocks.xmpp.extensions.rsm.model.ResultSetManagement;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.concurrent.AsyncResult;

public final class ClientServiceDiscoveryManager
extends AbstractServiceDiscoveryManager {
    private static final Identity DEFAULT_IDENTITY = Identity.clientPc();
    private final Set<Consumer<EventObject>> capabilitiesChangeListeners = new CopyOnWriteArraySet<Consumer<EventObject>>();
    private final ClientInfo clientInfo = new ClientInfo();
    private final List<DiscoverableInfo> discoverableInfos = new ArrayList<DiscoverableInfo>();
    private final DiscoverableInfo rootNode;
    private final XmppSession xmppSession;

    private ClientServiceDiscoveryManager(XmppSession xmppSession) {
        this.xmppSession = xmppSession;
        this.discoverableInfos.add(this.clientInfo);
        this.rootNode = new CombinedRootNode();
        this.addInfoProvider((to, from, node, locale) -> {
            if (node == null) {
                return this.rootNode;
            }
            return null;
        });
    }

    public final void addCapabilitiesChangeListener(Consumer<EventObject> listener) {
        this.capabilitiesChangeListeners.add(listener);
    }

    public final void removeCapabilitiesChangeListener(Consumer<EventObject> listener) {
        this.capabilitiesChangeListeners.remove(listener);
    }

    public final Set<Identity> getIdentities() {
        return Collections.unmodifiableSet(this.clientInfo.getIdentities());
    }

    public final List<DataForm> getExtensions() {
        return Collections.unmodifiableList(this.clientInfo.getExtensions());
    }

    public final void addIdentity(Identity identity) {
        if (this.clientInfo.getIdentities().add(identity) && this.xmppSession.isConnected()) {
            XmppUtils.notifyEventListeners(this.capabilitiesChangeListeners, (EventObject)new EventObject((Object)this));
        }
    }

    public final void removeIdentity(Identity identity) {
        if (this.clientInfo.getIdentities().remove(identity) && this.xmppSession.isConnected()) {
            XmppUtils.notifyEventListeners(this.capabilitiesChangeListeners, (EventObject)new EventObject((Object)this));
        }
    }

    public final void addFeature(String feature) {
        if (this.clientInfo.features.add(feature) && this.xmppSession.isConnected()) {
            XmppUtils.notifyEventListeners(this.capabilitiesChangeListeners, (EventObject)new EventObject((Object)this));
        }
    }

    public final void removeFeature(String feature) {
        if (this.clientInfo.features.remove(feature) && this.xmppSession.isConnected()) {
            XmppUtils.notifyEventListeners(this.capabilitiesChangeListeners, (EventObject)new EventObject((Object)this));
        }
    }

    public final DiscoverableInfo getDefaultInfo() {
        return this.rootNode;
    }

    public final void addExtension(DataForm extension) {
        this.clientInfo.getExtensions().add(extension);
        if (this.xmppSession.isConnected()) {
            XmppUtils.notifyEventListeners(this.capabilitiesChangeListeners, (EventObject)new EventObject((Object)this));
        }
    }

    public final void removeExtension(DataForm extension) {
        if (this.clientInfo.getExtensions().remove(extension) && this.xmppSession.isConnected()) {
            XmppUtils.notifyEventListeners(this.capabilitiesChangeListeners, (EventObject)new EventObject((Object)this));
        }
    }

    public final void addInfo(DiscoverableInfo discoverableInfo) {
        this.discoverableInfos.add(discoverableInfo);
    }

    public final AsyncResult<DiscoverableInfo> discoverInformation(Jid jid, String node) {
        return this.xmppSession.query(IQ.get((Jid)jid, (Object)new InfoDiscovery(node)), DiscoverableInfo.class);
    }

    public final AsyncResult<ItemNode> discoverItems(Jid jid, String node, ResultSetManagement resultSetManagement) {
        return this.xmppSession.query(IQ.get((Jid)jid, (Object)new ItemDiscovery(node, resultSetManagement)), ItemNode.class);
    }

    private static final class ClientInfo
    implements DiscoverableInfo {
        private final Set<Identity> identities = Collections.newSetFromMap(new ConcurrentHashMap());
        private final Set<String> features = Collections.newSetFromMap(new ConcurrentHashMap());
        private final CopyOnWriteArrayList<DataForm> extensions = new CopyOnWriteArrayList();

        private ClientInfo() {
            this.identities.add(DEFAULT_IDENTITY);
        }

        public Set<Identity> getIdentities() {
            return this.identities;
        }

        public Set<String> getFeatures() {
            return this.features;
        }

        public List<DataForm> getExtensions() {
            return this.extensions;
        }
    }

    private final class CombinedRootNode
    implements DiscoverableInfo {
        private CombinedRootNode() {
        }

        public final Set<Identity> getIdentities() {
            return ClientServiceDiscoveryManager.this.discoverableInfos.stream().flatMap(discoverableInfo -> discoverableInfo.getIdentities().stream()).collect(Collectors.toSet());
        }

        public final Set<String> getFeatures() {
            return ClientServiceDiscoveryManager.this.discoverableInfos.stream().flatMap(discoverableInfo -> discoverableInfo.getFeatures().stream()).collect(Collectors.toSet());
        }

        public final List<DataForm> getExtensions() {
            return ClientServiceDiscoveryManager.this.discoverableInfos.stream().flatMap(discoverableInfo -> discoverableInfo.getExtensions().stream()).collect(Collectors.toList());
        }
    }
}

