/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.httpbind;

import java.io.IOException;
import java.io.Reader;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.bind.DatatypeConverter;
import rocks.xmpp.core.Session;
import rocks.xmpp.core.net.AbstractConnection;
import rocks.xmpp.core.net.ChannelEncryption;
import rocks.xmpp.core.net.Connection;
import rocks.xmpp.core.net.ConnectionConfiguration;
import rocks.xmpp.core.net.ReaderInterceptor;
import rocks.xmpp.core.net.ReaderInterceptorChain;
import rocks.xmpp.core.net.WriterInterceptor;
import rocks.xmpp.core.net.WriterInterceptorChain;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.model.SessionOpen;
import rocks.xmpp.core.stanza.model.Stanza;
import rocks.xmpp.core.stream.StreamHandler;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.core.stream.model.StreamError;
import rocks.xmpp.core.stream.model.StreamErrorException;
import rocks.xmpp.core.stream.model.StreamFeatures;
import rocks.xmpp.core.stream.model.StreamHeader;
import rocks.xmpp.dns.DnsResolver;
import rocks.xmpp.dns.TxtRecord;
import rocks.xmpp.extensions.compress.CompressionMethod;
import rocks.xmpp.extensions.httpbind.BoshConnectionConfiguration;
import rocks.xmpp.extensions.httpbind.BoshException;
import rocks.xmpp.extensions.httpbind.model.Body;
import rocks.xmpp.util.XmppStreamDecoder;
import rocks.xmpp.util.XmppStreamEncoder;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.concurrent.QueuedScheduledExecutorService;

public abstract class BoshConnection
extends AbstractConnection {
    static final ExecutorService HTTP_BIND_EXECUTOR = Executors.newCachedThreadPool(XmppUtils.createNamedThreadFactory((String)"BOSH Request Thread"));
    protected static final System.Logger logger = System.getLogger(BoshConnection.class.getName());
    final ScheduledExecutorService inOrderRequestExecutor = new QueuedScheduledExecutorService((Executor)HTTP_BIND_EXECUTOR);
    final ScheduledExecutorService inOrderResponseExecutor = new QueuedScheduledExecutorService((Executor)HTTP_BIND_EXECUTOR);
    protected final XmppSession xmppSession;
    protected final URL url;
    final BoshConnectionConfiguration boshConnectionConfiguration;
    final Map<String, CompressionMethod> compressionMethods;
    final String clientAcceptEncoding;
    final Map<Long, Body.Builder> unacknowledgedRequests = new ConcurrentSkipListMap<Long, Body.Builder>();
    private final AtomicLong rid = new AtomicLong();
    private final Deque<String> keySequence = new ArrayDeque<String>();
    private final AtomicInteger requestCount = new AtomicInteger();
    private final Map<StreamElement, CompletableFuture<Void>> sendFutures = new ConcurrentHashMap<StreamElement, CompletableFuture<Void>>();
    private final Collection<Object> elementsToSend = new ArrayDeque<Object>();
    private final CompletableFuture<Void> closeFuture = new CompletableFuture();
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final XmppStreamEncoder streamEncoder;
    private final XmppStreamDecoder streamDecoder;
    CompressionMethod requestCompressionMethod;
    private long highestReceivedRid;
    private String sessionId;
    private boolean usingAcknowledgments;
    private SessionOpen sessionOpen;

    BoshConnection(URL url, XmppSession xmppSession, BoshConnectionConfiguration configuration) {
        super((ConnectionConfiguration)configuration, (StreamHandler)xmppSession, xmppSession::notifyException);
        this.url = url;
        this.xmppSession = xmppSession;
        this.boshConnectionConfiguration = configuration;
        this.compressionMethods = new LinkedHashMap<String, CompressionMethod>();
        for (CompressionMethod compressionMethod : this.boshConnectionConfiguration.getCompressionMethods()) {
            this.compressionMethods.put(compressionMethod.getName(), compressionMethod);
        }
        this.clientAcceptEncoding = !this.compressionMethods.isEmpty() ? String.join((CharSequence)",", this.compressionMethods.keySet()) : null;
        this.streamEncoder = new XmppStreamEncoder(xmppSession.getConfiguration().getXmlOutputFactory(), xmppSession::createMarshaller, s -> {
            if (s instanceof Body) {
                return ((Body)s).getWrappedObjects().stream().map(Object::getClass).anyMatch(clazz -> clazz == StreamFeatures.class || clazz == StreamError.class);
            }
            return false;
        });
        this.streamDecoder = new XmppStreamDecoder(xmppSession.getConfiguration().getXmlInputFactory(), xmppSession::createUnmarshaller, "");
        this.rid.set(new BigInteger(52, new Random()).longValue());
    }

    private static void handleCode(int httpCode) throws BoshException {
        if (httpCode != 200) {
            switch (httpCode) {
                case 400: {
                    throw new BoshException(Body.Condition.BAD_REQUEST, httpCode);
                }
                case 403: {
                    throw new BoshException(Body.Condition.POLICY_VIOLATION, httpCode);
                }
                case 404: {
                    throw new BoshException(Body.Condition.ITEM_NOT_FOUND, httpCode);
                }
            }
            throw new BoshException(Body.Condition.UNDEFINED_CONDITION, httpCode);
        }
    }

    static URL getUrl(XmppSession xmppSession, BoshConnectionConfiguration configuration) throws MalformedURLException {
        URL url;
        int targetPort;
        String protocol;
        String string = protocol = configuration.getChannelEncryption() == ChannelEncryption.DIRECT ? "https" : "http";
        int n = configuration.getPort() > 0 ? configuration.getPort() : (targetPort = configuration.getChannelEncryption() == ChannelEncryption.DIRECT ? 5281 : 5280);
        if (configuration.getHostname() != null) {
            url = new URL(protocol, configuration.getHostname(), targetPort, configuration.getPath());
        } else if (xmppSession.getDomain() != null) {
            String resolvedUrl = BoshConnection.findBoshUrl(xmppSession.getDomain().toString(), xmppSession.getConfiguration().getNameServer(), configuration.getConnectTimeout());
            url = resolvedUrl != null ? new URL(resolvedUrl) : new URL(protocol, xmppSession.getDomain().toString(), targetPort, configuration.getPath());
        } else {
            throw new IllegalStateException("Neither an URL nor a domain given for a BOSH connection.");
        }
        return url;
    }

    private static String findBoshUrl(String xmppServiceDomain, String nameServer, long timeout) {
        try {
            List<TxtRecord> txtRecords = DnsResolver.resolveTXT(xmppServiceDomain, nameServer, timeout);
            for (TxtRecord txtRecord : txtRecords) {
                Map<String, String> attributes = txtRecord.asAttributes();
                String url = attributes.get("_xmpp-client-xbosh");
                if (url == null) continue;
                return url;
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    WriterInterceptorChain newWriterChain() {
        ArrayList<WriterInterceptor> writerInterceptors = new ArrayList<WriterInterceptor>(this.xmppSession.getWriterInterceptors());
        writerInterceptors.add((WriterInterceptor)this.streamEncoder);
        return new WriterInterceptorChain(writerInterceptors, (Session)this.xmppSession, (Connection)this);
    }

    private ReaderInterceptorChain newReaderChain() {
        ArrayList<ReaderInterceptor> readerInterceptors = new ArrayList<ReaderInterceptor>(this.xmppSession.getReaderInterceptors());
        readerInterceptors.add((ReaderInterceptor)this.streamDecoder);
        return new ReaderInterceptorChain(readerInterceptors, (Session)this.xmppSession, (Connection)this);
    }

    private void generateKeySequence() {
        this.keySequence.clear();
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            SecureRandom random = new SecureRandom();
            int n = 256 + random.nextInt(32512);
            byte[] seed = new byte[1024];
            ((Random)random).nextBytes(seed);
            String kn = DatatypeConverter.printHexBinary((byte[])seed).toLowerCase();
            for (int i = 0; i < n; ++i) {
                kn = DatatypeConverter.printHexBinary((byte[])digest.digest(kn.getBytes(StandardCharsets.UTF_8))).toLowerCase();
                this.keySequence.add(kn);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CompletionStage<Void> open(SessionOpen sessionOpen) {
        BoshConnection boshConnection = this;
        synchronized (boshConnection) {
            this.sessionOpen = sessionOpen;
        }
        Body.Builder body = Body.builder().language(this.xmppSession.getConfiguration().getLanguage()).version("1.11").wait(this.boshConnectionConfiguration.getWait()).hold((short)1).route(this.boshConnectionConfiguration.getRoute()).ack(1L).from(sessionOpen.getFrom()).xmppVersion("1.0");
        if (this.xmppSession.getDomain() != null) {
            body.to(this.xmppSession.getDomain());
        }
        return this.sendNewRequest(body, false);
    }

    public final boolean isSecure() {
        return this.boshConnectionConfiguration.getChannelEncryption() == ChannelEncryption.DIRECT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpackBody(Body responseBody) throws Exception {
        if (responseBody.getSid() != null) {
            this.handleElement(responseBody);
            BoshConnection boshConnection = this;
            synchronized (boshConnection) {
                this.sessionId = responseBody.getSid();
                if (responseBody.getAck() != null) {
                    this.usingAcknowledgments = true;
                }
                if (responseBody.getAccept() != null) {
                    String[] serverAcceptedEncodings;
                    for (String serverAcceptedEncoding : serverAcceptedEncodings = responseBody.getAccept().split(",", 16)) {
                        this.requestCompressionMethod = this.compressionMethods.get(serverAcceptedEncoding.trim().toLowerCase());
                        if (this.requestCompressionMethod != null) break;
                    }
                }
            }
        }
        if (responseBody.getAck() != null) {
            this.ackReceived(responseBody.getAck());
        }
        for (Object wrappedObject : responseBody.getWrappedObjects()) {
            this.handleElement(wrappedObject);
        }
        if (responseBody.getType() == Body.Type.TERMINATE) {
            this.handleElement(StreamHeader.CLOSING_STREAM_TAG);
            if (responseBody.getCondition() != null && responseBody.getCondition() != Body.Condition.REMOTE_STREAM_ERROR) {
                this.shutdown();
                this.closeFuture.completeExceptionally((Throwable)((Object)new BoshException(responseBody.getCondition(), responseBody.getUri())));
                throw new BoshException(responseBody.getCondition(), responseBody.getUri());
            }
        } else if (responseBody.getType() == Body.Type.ERROR) {
            this.unacknowledgedRequests.forEach((key, value) -> this.sendNewRequest((Body.Builder)value, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void restartStream() {
        Body.Builder bodyBuilder;
        BoshConnection boshConnection = this;
        synchronized (boshConnection) {
            bodyBuilder = Body.builder().sessionId(this.sessionId).restart(true).to(this.xmppSession.getDomain()).language(this.xmppSession.getConfiguration().getLanguage()).from(this.sessionOpen.getFrom());
        }
        this.sendNewRequest(bodyBuilder, false);
    }

    protected CompletionStage<Void> closeStream() {
        CompletableFuture<Object> future;
        if (!this.shutdown.get()) {
            String sid = this.getSessionId();
            if (sid != null) {
                Body.Builder bodyBuilder = Body.builder().sessionId(sid).type(Body.Type.TERMINATE);
                future = this.sendNewRequest(bodyBuilder, false);
            } else {
                future = CompletableFuture.completedFuture(null);
            }
            this.shutdown();
        } else {
            future = CompletableFuture.completedFuture(null);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletionStage<Void> closeConnection() {
        try {
            BoshConnection boshConnection = this;
            synchronized (boshConnection) {
                this.sessionId = null;
                this.requestCompressionMethod = null;
                this.keySequence.clear();
            }
        }
        finally {
            this.closeFuture.complete(null);
            this.shutdown();
        }
        return this.closeFuture;
    }

    public final CompletionStage<Void> closeFuture() {
        return this.closeFuture;
    }

    private void shutdown() {
        this.shutdown.set(true);
    }

    public final long detach() {
        this.shutdown();
        return this.rid.get();
    }

    public final CompletableFuture<Void> send(StreamElement element) {
        CompletionStage future = this.write(element);
        this.flush();
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CompletableFuture<Void> write(StreamElement streamElement) {
        Collection<Object> collection = this.elementsToSend;
        synchronized (collection) {
            this.elementsToSend.add(streamElement);
        }
        CompletableFuture<Void> sendFuture = new CompletableFuture<Void>();
        this.sendFutures.put(streamElement, sendFuture);
        return sendFuture;
    }

    public final void flush() {
        this.sendNewRequest(Body.builder().sessionId(this.getSessionId()), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendKey(Body.Builder bodyBuilder) {
        if (this.boshConnectionConfiguration.isUseKeySequence()) {
            Deque<String> deque = this.keySequence;
            synchronized (deque) {
                if (this.keySequence.isEmpty()) {
                    this.generateKeySequence();
                    bodyBuilder.newKey(this.keySequence.removeLast());
                } else {
                    bodyBuilder.key(this.keySequence.removeLast());
                    if (this.keySequence.isEmpty()) {
                        this.generateKeySequence();
                        bodyBuilder.newKey(this.keySequence.removeLast());
                    }
                }
            }
        }
    }

    public final synchronized String getSessionId() {
        return this.sessionId;
    }

    public final InetSocketAddress getRemoteAddress() {
        return InetSocketAddress.createUnresolved(this.url.getHost(), this.url.getPort());
    }

    public final synchronized boolean isUsingAcknowledgements() {
        return this.usingAcknowledgments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> sendNewRequest(Body.Builder bodyBuilder, boolean resendAfterError) {
        if (!this.shutdown.get()) {
            if (!resendAfterError) {
                Collection<Object> collection = this.elementsToSend;
                synchronized (collection) {
                    Body b = bodyBuilder.build();
                    if (b.getType() != Body.Type.TERMINATE && (this.shutdown.get() || this.requestCount.get() > 0 && b.getPause() == null && !b.isRestart() && this.getSessionId() != null && this.elementsToSend.isEmpty())) {
                        return CompletableFuture.completedFuture(null);
                    }
                    this.appendKey(bodyBuilder);
                    if (!this.unacknowledgedRequests.isEmpty()) {
                        bodyBuilder.ack(this.highestReceivedRid);
                    }
                    bodyBuilder.wrappedObjects(this.elementsToSend);
                    this.elementsToSend.clear();
                }
            }
            this.requestCount.getAndIncrement();
            Body body = bodyBuilder.requestId(this.rid.getAndIncrement()).build();
            if (this.isUsingAcknowledgements()) {
                this.unacknowledgedRequests.put(body.getRid(), bodyBuilder);
            }
            return this.sendBody(body).whenComplete((aVoid, exc) -> {
                body.getWrappedObjects().stream().filter(wrappedObject -> wrappedObject instanceof StreamElement).forEach(wrappedObject -> {
                    StreamElement streamElement = (StreamElement)wrappedObject;
                    CompletableFuture<Void> future = this.sendFutures.remove(streamElement);
                    if (future != null) {
                        if (exc != null) {
                            future.completeExceptionally((Throwable)exc);
                        } else {
                            future.complete(null);
                        }
                    }
                });
                if (exc != null) {
                    this.rid.getAndDecrement();
                    this.xmppSession.notifyException((Throwable)exc);
                    throw exc instanceof CompletionException ? (CompletionException)exc : new CompletionException((Throwable)exc);
                }
            });
        }
        throw new IllegalStateException("Connection already shutdown via close() or detach()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void handleSuccessfulResponse(Reader reader, Body requestBody) throws Exception {
        try {
            this.ackReceived(requestBody.getRid());
            Collection<Object> collection = this.elementsToSend;
            synchronized (collection) {
                this.highestReceivedRid = requestBody.getRid() != null ? requestBody.getRid() : 0L;
            }
            ReaderInterceptorChain readerInterceptorChain = this.newReaderChain();
            ArrayList streamElements = new ArrayList();
            readerInterceptorChain.proceed(reader, streamElements::add);
            for (StreamElement element : streamElements) {
                if (!(element instanceof Body)) continue;
                this.unpackBody((Body)element);
            }
        }
        catch (StreamErrorException e) {
            logger.log(System.Logger.Level.WARNING, "Server responded with malformed XML.", (Throwable)e);
        }
        finally {
            if (this.requestCount.decrementAndGet() == 0) {
                this.inOrderRequestExecutor.schedule(() -> this.sendNewRequest(Body.builder().sessionId(this.sessionId), false), 100L, TimeUnit.MILLISECONDS);
            }
        }
    }

    final void handleErrorHttpResponse(int httpResponseCode) throws BoshException {
        this.shutdown();
        BoshConnection.handleCode(httpResponseCode);
    }

    protected abstract CompletableFuture<Void> sendBody(Body var1);

    private void ackReceived(Long rid) {
        Body.Builder body;
        if (rid != null && (body = this.unacknowledgedRequests.remove(rid)) != null) {
            body.build().getWrappedObjects().stream().filter(object -> object instanceof Stanza).forEach(object -> {
                Stanza stanza = (Stanza)object;
                this.xmppSession.markAcknowledged(stanza);
            });
        }
    }

    public final String getRoute() {
        return this.boshConnectionConfiguration.getRoute();
    }
}

