/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.httpbind;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import rocks.xmpp.core.net.Connection;
import rocks.xmpp.core.net.client.ClientConnectionConfiguration;
import rocks.xmpp.core.net.client.TransportConnector;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.session.model.SessionOpen;
import rocks.xmpp.extensions.httpbind.BoshConnection;
import rocks.xmpp.extensions.httpbind.BoshConnectionConfiguration;
import rocks.xmpp.extensions.httpbind.HttpClientBoshConnection;

public final class HttpClientConnector
implements TransportConnector<BoshConnectionConfiguration> {
    @Override
    public final CompletableFuture<Connection> connect(XmppSession xmppSession, BoshConnectionConfiguration configuration, SessionOpen sessionOpen) {
        try {
            HttpClientBoshConnection boshConnection = new HttpClientBoshConnection(BoshConnection.getUrl(xmppSession, configuration), xmppSession, configuration);
            return boshConnection.open(sessionOpen).thenApply(aVoid -> boshConnection).toCompletableFuture();
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public static HttpClient.Builder newHttpClientBuilder(ClientConnectionConfiguration connectionConfiguration) {
        HttpClient.Builder builder = HttpClient.newBuilder();
        if (connectionConfiguration.getSSLContext() != null) {
            builder.sslContext(connectionConfiguration.getSSLContext());
        }
        if (connectionConfiguration.getProxy() != null) {
            builder.proxy(ProxySelector.of((InetSocketAddress)connectionConfiguration.getProxy().address()));
        }
        if (connectionConfiguration.getConnectTimeout() > 0) {
            builder.connectTimeout(Duration.ofMillis(connectionConfiguration.getConnectTimeout()));
        }
        return builder;
    }
}

