/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.httpbind;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import javax.net.ssl.HttpsURLConnection;
import rocks.xmpp.core.net.WriterInterceptorChain;
import rocks.xmpp.core.session.XmppSession;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.core.stream.model.StreamErrorException;
import rocks.xmpp.extensions.compress.CompressionMethod;
import rocks.xmpp.extensions.httpbind.BoshConnection;
import rocks.xmpp.extensions.httpbind.BoshConnectionConfiguration;
import rocks.xmpp.extensions.httpbind.model.Body;

final class HttpUrlBoshConnection
extends BoshConnection {
    HttpUrlBoshConnection(URL url, XmppSession xmppSession, BoshConnectionConfiguration configuration) {
        super(url, xmppSession, configuration);
    }

    @Override
    public CompletableFuture<Void> sendBody(Body body) {
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                CompressionMethod compressionMethod;
                HttpURLConnection httpConnection = this.getConnection();
                httpConnection.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
                if (this.clientAcceptEncoding != null) {
                    httpConnection.setRequestProperty("Accept-Encoding", this.clientAcceptEncoding);
                }
                if ((compressionMethod = this.requestCompressionMethod) != null) {
                    httpConnection.setRequestProperty("Content-Encoding", compressionMethod.getName());
                }
                httpConnection.setDoOutput(true);
                httpConnection.setRequestMethod("POST");
                httpConnection.setReadTimeout(((int)this.boshConnectionConfiguration.getWait().getSeconds() + 5) * 1000);
                try (OutputStream requestStream = compressionMethod != null ? compressionMethod.compress(httpConnection.getOutputStream()) : httpConnection.getOutputStream();
                     OutputStreamWriter writer = new OutputStreamWriter(requestStream, StandardCharsets.UTF_8);){
                    WriterInterceptorChain writerInterceptorChain = this.newWriterChain();
                    writerInterceptorChain.proceed((StreamElement)body, (Writer)writer);
                }
                return httpConnection;
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, this.inOrderRequestExecutor).thenApplyAsync(httpURLConnection -> {
            try {
                httpURLConnection.getResponseCode();
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
            return httpURLConnection;
        }, (Executor)HTTP_BIND_EXECUTOR)).thenApplyAsync(httpConnection -> {
            block23: {
                try {
                    if (httpConnection.getResponseCode() == 200) {
                        String contentEncoding = httpConnection.getHeaderField("Content-Encoding");
                        try (InputStream responseStream = contentEncoding != null ? ((CompressionMethod)this.compressionMethods.get(contentEncoding)).decompress(httpConnection.getInputStream()) : httpConnection.getInputStream();){
                            try (InputStreamReader reader = new InputStreamReader(responseStream, StandardCharsets.UTF_8);){
                                this.handleSuccessfulResponse(reader, body);
                                break block23;
                            }
                            catch (StreamErrorException e) {
                                logger.log(System.Logger.Level.WARNING, "Server responded with malformed XML.", (Throwable)e);
                            }
                            break block23;
                        }
                    }
                    this.handleErrorHttpResponse(httpConnection.getResponseCode());
                    try (InputStream errorStream = httpConnection.getErrorStream();){
                        while (errorStream.read() > -1) {
                        }
                    }
                }
                catch (Exception e) {
                    throw new CompletionException(e);
                }
            }
            return httpConnection;
        }, (Executor)this.inOrderResponseExecutor)).handle((httpConnection, exc) -> {
            if (httpConnection != null) {
                httpConnection.disconnect();
            }
            if (exc != null) {
                throw exc instanceof CompletionException ? (CompletionException)exc : new CompletionException((Throwable)exc);
            }
            return null;
        });
    }

    private HttpURLConnection getConnection() throws IOException {
        Proxy proxy = this.boshConnectionConfiguration.getProxy();
        HttpURLConnection httpURLConnection = proxy != null ? (HttpURLConnection)this.url.openConnection(proxy) : (HttpURLConnection)this.url.openConnection();
        if (httpURLConnection instanceof HttpsURLConnection) {
            if (this.boshConnectionConfiguration.getSSLContext() != null) {
                ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(this.boshConnectionConfiguration.getSSLContext().getSocketFactory());
            }
            if (this.boshConnectionConfiguration.getHostnameVerifier() != null) {
                ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(this.boshConnectionConfiguration.getHostnameVerifier());
            }
        }
        return httpURLConnection;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder("BOSH connection to ").append(this.url);
        String streamId = this.getStreamId();
        if (streamId != null) {
            sb.append(" (").append(streamId).append(')');
        }
        sb.append(" using java.net.HttpURLConnection");
        return sb.toString();
    }
}

