/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core;

import java.text.Collator;
import java.util.Locale;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import rocks.xmpp.util.adapters.LocaleAdapter;

public final class Text
implements CharSequence,
Comparable<Text> {
    @XmlJavaTypeAdapter(value=LocaleAdapter.class)
    @XmlAttribute(namespace="http://www.w3.org/XML/1998/namespace")
    private final Locale lang;
    @XmlValue
    private final String text;

    private Text() {
        this.text = null;
        this.lang = null;
    }

    public Text(String text) {
        this(text, null);
    }

    public Text(String text, Locale language) {
        this.text = Objects.requireNonNull(text);
        this.lang = language;
    }

    public final Locale getLanguage() {
        return this.lang;
    }

    public final String getText() {
        return this.text;
    }

    @Override
    public final int length() {
        return this.toString().length();
    }

    @Override
    public final char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public final CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    public final int compareTo(Text o) {
        if (o == null) {
            return -1;
        }
        Collator collator = this.lang != null ? Collator.getInstance(this.lang) : Collator.getInstance();
        int result = collator.compare(this.text, o.text);
        if (result == 0) {
            if (this.lang != null) {
                if (o.lang != null) {
                    return this.lang.toLanguageTag().compareTo(o.lang.toLanguageTag());
                }
                return 1;
            }
            if (o.lang == null) {
                return 0;
            }
            return -1;
        }
        return result;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Text)) {
            return false;
        }
        Text other = (Text)o;
        return Objects.equals(this.text, other.getText()) && Objects.equals(this.lang, other.getLanguage());
    }

    public final int hashCode() {
        return Objects.hash(this.text, this.lang);
    }

    @Override
    public final String toString() {
        return this.text;
    }
}

