/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stanza.model;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.Text;
import rocks.xmpp.core.stanza.model.ExtensibleStanza;
import rocks.xmpp.core.stanza.model.StanzaError;
import rocks.xmpp.core.stanza.model.errors.Condition;

@XmlTransient
public class Message
extends ExtensibleStanza {
    private final List<Text> subject = new CopyOnWriteArrayList<Text>();
    private final List<Text> body = new CopyOnWriteArrayList<Text>();
    @XmlAttribute
    private Type type;
    private ThreadElement thread;

    public Message() {
        this(null);
    }

    public Message(Jid to) {
        this(to, null);
    }

    public Message(Jid to, Type type) {
        this(to, type, null);
    }

    public Message(Jid to, Type type, String body) {
        this(to, type, body, null);
    }

    public Message(Jid to, Type type, String body, String subject) {
        this(to, type, body, subject, null);
    }

    public Message(Jid to, Type type, String body, String subject, String thread) {
        this(to, type, body != null ? Collections.singleton(new Text(body)) : Collections.emptyList(), subject != null ? Collections.singleton(new Text(subject)) : Collections.emptyList(), thread, null, null, null, null, null, null);
    }

    public Message(Jid to, Type type, String body, String subject, String thread, String parentThread, String id, Jid from, Locale language, Collection<?> extensions, StanzaError error) {
        this(to, type, body != null ? Collections.singleton(new Text(body)) : Collections.emptyList(), subject != null ? Collections.singleton(new Text(subject)) : Collections.emptyList(), thread, parentThread, id, from, language, extensions, error);
    }

    public Message(Jid to, Type type, Collection<Text> bodies, Collection<Text> subjects, String thread, String parentThread, String id, Jid from, Locale language, Collection<?> extensions, StanzaError error) {
        super(to, from, id, language, extensions, error);
        this.type = type;
        if (bodies != null) {
            this.body.addAll(bodies);
        }
        if (subjects != null) {
            this.subject.addAll(subjects);
        }
        this.thread = thread != null || parentThread != null ? new ThreadElement(thread, parentThread) : null;
    }

    public final List<Text> getBodies() {
        return this.body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getBody() {
        for (Text body : this.body) {
            if (body.getLanguage() != null) continue;
            return body.getText();
        }
        Message message = this;
        synchronized (message) {
            if (!this.body.isEmpty()) {
                return this.body.get(0).getText();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setBody(String body) {
        if (body != null) {
            Message message = this;
            synchronized (message) {
                for (Text b : this.body) {
                    if (b.getLanguage() != null) continue;
                    this.body.remove(b);
                    break;
                }
                this.body.add(0, new Text(body));
            }
        } else {
            this.body.clear();
        }
    }

    public final List<Text> getSubjects() {
        return this.subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getSubject() {
        for (Text subject : this.subject) {
            if (subject.getLanguage() != null) continue;
            return subject.getText();
        }
        Message message = this;
        synchronized (message) {
            if (!this.subject.isEmpty()) {
                return this.subject.get(0).getText();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSubject(String subject) {
        if (subject != null) {
            Message message = this;
            synchronized (message) {
                for (Text s : this.subject) {
                    if (s.getLanguage() != null) continue;
                    this.subject.remove(s);
                    break;
                }
                this.subject.add(0, new Text(subject));
            }
        } else {
            this.subject.clear();
        }
    }

    public final synchronized Type getType() {
        return this.type;
    }

    public final synchronized void setType(Type type) {
        this.type = type;
    }

    public final synchronized boolean isNormal() {
        return this.type == Type.NORMAL || this.type == null;
    }

    public final synchronized String getThread() {
        if (this.thread != null) {
            return this.thread.value;
        }
        return null;
    }

    public final synchronized void setThread(String thread) {
        this.thread = thread != null ? new ThreadElement(thread, null) : null;
    }

    public final synchronized String getParentThread() {
        if (this.thread != null) {
            return this.thread.parent;
        }
        return null;
    }

    public final synchronized void setParentThread(String parent) {
        this.thread = new ThreadElement(this.thread != null ? this.thread.value : null, parent);
    }

    @Override
    public final Message createError(StanzaError error) {
        return new Message(this.getFrom(), Type.ERROR, this.getBodies(), this.getSubjects(), this.getThread(), this.getParentThread(), this.getId(), this.getTo(), this.getLanguage(), this.getExtensions(), error);
    }

    @Override
    public final Message createError(Condition condition) {
        return this.createError(new StanzaError(condition));
    }

    @Override
    public final synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.type != null) {
            String sType = this.type.name();
            sb.append(sType.substring(0, 1)).append(sType.substring(1).toLowerCase()).append(' ');
        }
        sb.append("Message").append(super.toString());
        String body = this.getBody();
        if (body != null) {
            sb.append(": ").append(body);
        }
        return sb.toString();
    }

    private static final class ThreadElement {
        @XmlAttribute
        private final String parent;
        @XmlValue
        private final String value;

        private ThreadElement() {
            this(null, null);
        }

        private ThreadElement(String value, String parent) {
            this.value = value;
            this.parent = parent;
        }

        public final String toString() {
            return this.value;
        }
    }

    @XmlType(name="messageType")
    public static enum Type {
        NORMAL,
        CHAT,
        HEADLINE,
        GROUPCHAT,
        ERROR;

    }
}

