/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.util.concurrent;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import rocks.xmpp.util.XmppUtils;
import rocks.xmpp.util.concurrent.QueuedExecutorService;

public class QueuedScheduledExecutorService
extends QueuedExecutorService
implements ScheduledExecutorService {
    private static final ScheduledThreadPoolExecutor SCHEDULER = new ScheduledThreadPoolExecutor(1, XmppUtils.createNamedThreadFactory("Scheduler Thread"));
    private static final AtomicLong SEQUENCER = new AtomicLong();
    private final Set<RunnableScheduledFuture<?>> futures = new HashSet();
    private volatile boolean keepPeriodic = false;
    private volatile boolean keepDelayed = true;
    private volatile boolean removeOnCancel = false;

    public QueuedScheduledExecutorService(ExecutorService delegate) {
        super(delegate);
    }

    @Override
    public boolean isTerminated() {
        return super.isTerminated() && this.futures.isEmpty();
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return new ScheduledFutureTask(Executors.callable(command, null), this.getInitialDelay(delay, unit), unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return new ScheduledFutureTask(callable, this.getInitialDelay(delay, unit), unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return new ScheduledFutureTask(Executors.callable(command, null), this.getInitialDelay(initialDelay, unit), period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return new ScheduledFutureTask(Executors.callable(command, null), this.getInitialDelay(initialDelay, unit), -delay, unit);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.onShutdown();
    }

    public void setContinueExistingPeriodicTasksAfterShutdownPolicy(boolean value) {
        this.keepPeriodic = value;
        if (!value && this.isShutdown()) {
            this.onShutdown();
        }
    }

    public void setExecuteExistingDelayedTasksAfterShutdownPolicy(boolean value) {
        this.keepDelayed = value;
        if (!value && this.isShutdown()) {
            this.onShutdown();
        }
    }

    public void setRemoveOnCancelPolicy(boolean removeOnCancel) {
        this.removeOnCancel = removeOnCancel;
    }

    private long getInitialDelay(long delay, TimeUnit unit) {
        return System.nanoTime() + unit.toNanos(delay);
    }

    private void onShutdown() {
        for (RunnableScheduledFuture<?> future : new HashSet(this.futures)) {
            if (!(!future.isPeriodic() ? !this.keepDelayed : !this.keepPeriodic) && !future.isCancelled()) continue;
            future.cancel(false);
        }
    }

    private class ScheduledFutureTask<V>
    extends FutureTask<V>
    implements RunnableScheduledFuture<V> {
        private final Callable<V> callable;
        private final long period;
        private final long sequence;
        private long time;

        private ScheduledFutureTask(Callable<V> callable, long initial, TimeUnit unit) {
            this(callable, initial, 0L, unit);
        }

        private ScheduledFutureTask(Callable<V> callable, long time, long period, TimeUnit unit) {
            super(callable);
            this.callable = callable;
            this.period = unit.toNanos(period);
            this.sequence = SEQUENCER.getAndIncrement();
            this.time = time;
            QueuedScheduledExecutorService.this.futures.add(this);
            this.queueNextRun();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean cancelled = super.cancel(mayInterruptIfRunning);
            if (cancelled && QueuedScheduledExecutorService.this.removeOnCancel) {
                SCHEDULER.remove(this);
            }
            return cancelled;
        }

        @Override
        public boolean isCancelled() {
            return super.isCancelled();
        }

        @Override
        public boolean isDone() {
            return super.isDone();
        }

        @Override
        public boolean isPeriodic() {
            return this.period != 0L;
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return super.get();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return super.get(timeout, unit);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.time - System.nanoTime(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            if (other instanceof ScheduledFutureTask) {
                ScheduledFutureTask otherTask = (ScheduledFutureTask)other;
                long deltaTime = this.time - otherTask.time;
                if (deltaTime < 0L) {
                    return -1;
                }
                if (deltaTime > 0L) {
                    return 1;
                }
                if (this.sequence < otherTask.sequence) {
                    return -1;
                }
                return 1;
            }
            long deltaDelay = this.getDelay(TimeUnit.NANOSECONDS) - other.getDelay(TimeUnit.NANOSECONDS);
            return deltaDelay < 0L ? -1 : (deltaDelay > 0L ? 1 : 0);
        }

        @Override
        public void run() {
            QueuedScheduledExecutorService.this.execute(this::doRun, this.canRun());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            AtomicBoolean atomicBoolean = QueuedScheduledExecutorService.this.lock;
            synchronized (atomicBoolean) {
                QueuedScheduledExecutorService.this.futures.remove(this);
                QueuedScheduledExecutorService.this.lock.notifyAll();
            }
        }

        private boolean canRun() {
            return !QueuedScheduledExecutorService.this.isShutdown() || (this.isPeriodic() ? QueuedScheduledExecutorService.this.keepPeriodic : QueuedScheduledExecutorService.this.keepDelayed);
        }

        private void doRun() {
            boolean isPeriodic = this.isPeriodic();
            try {
                if (!this.canRun()) {
                    this.cancel(false);
                } else if (!isPeriodic) {
                    this.set(this.callable.call());
                } else {
                    this.callable.call();
                }
            }
            catch (Exception e) {
                this.setException(e);
            }
            finally {
                if (isPeriodic) {
                    this.time = this.period > 0L ? (this.time += this.period) : System.nanoTime() - this.period;
                    this.queueNextRun();
                }
            }
        }

        private void queueNextRun() {
            SCHEDULER.getQueue().add(this);
            if (QueuedScheduledExecutorService.this.isShutdown() && !this.canRun() && SCHEDULER.remove(this)) {
                this.cancel(false);
            } else {
                SCHEDULER.prestartCoreThread();
            }
        }
    }
}

