/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stanza;

import java.util.EnumSet;
import java.util.Set;
import rocks.xmpp.core.stanza.IQHandler;
import rocks.xmpp.core.stanza.model.IQ;
import rocks.xmpp.core.stanza.model.StanzaError;
import rocks.xmpp.core.stanza.model.errors.Condition;

public abstract class AbstractIQHandler
implements IQHandler {
    private final Set<IQ.Type> type;
    private final Class<?> clazz;

    protected AbstractIQHandler(Class<?> clazz, IQ.Type ... type) {
        this.clazz = clazz;
        if (type.length == 0) {
            throw new IllegalArgumentException("type type list must not be empty.");
        }
        if (type.length == 1) {
            this.type = EnumSet.of(type[0]);
        } else if (type.length == 2) {
            this.type = EnumSet.of(type[0], type[1]);
        } else {
            throw new IllegalArgumentException("Max 2 varargs allowed, which must be of type 'get' or 'set'.");
        }
        if (this.type.contains((Object)IQ.Type.ERROR) || this.type.contains((Object)IQ.Type.RESULT)) {
            throw new IllegalArgumentException("type must be 'get' and/or 'set'");
        }
    }

    @Override
    public final Class<?> getPayloadClass() {
        return this.clazz;
    }

    @Override
    public final IQ handleRequest(IQ iq) {
        if (this.type.contains((Object)iq.getType())) {
            return this.processRequest(iq);
        }
        return iq.createError(new StanzaError(Condition.BAD_REQUEST, "Type was '" + iq.getType().toString().toLowerCase() + "', but expected '" + this.type.toString().toLowerCase() + "'."));
    }

    protected abstract IQ processRequest(IQ var1);
}

