/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stanza.model;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.LanguageElement;
import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.core.stanza.model.StanzaError;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.util.adapters.LocaleAdapter;

@XmlTransient
public abstract class Stanza
implements LanguageElement,
StreamElement {
    @XmlAttribute
    private Jid from;
    @XmlAttribute
    private String id;
    @XmlAttribute
    private Jid to;
    @XmlAttribute(namespace="http://www.w3.org/XML/1998/namespace")
    @XmlJavaTypeAdapter(value=LocaleAdapter.class)
    private Locale lang;
    @XmlAnyElement(lax=true)
    final List<Object> extensions = new CopyOnWriteArrayList<Object>();
    private StanzaError error;

    Stanza() {
        this.to = null;
        this.from = null;
        this.id = null;
        this.lang = null;
        this.error = null;
    }

    Stanza(Jid to, Jid from, String id, Locale language, Collection<?> extensions, StanzaError error) {
        this.to = to;
        this.from = from;
        this.id = id;
        this.lang = language;
        if (extensions != null) {
            this.extensions.addAll(extensions);
        }
        this.error = error;
    }

    public final synchronized Jid getFrom() {
        return this.from;
    }

    public final synchronized void setFrom(Jid from) {
        this.from = from;
    }

    public final synchronized String getId() {
        return this.id;
    }

    public final synchronized void setId(String id) {
        this.id = id;
    }

    public final synchronized Jid getTo() {
        return this.to;
    }

    public final synchronized void setTo(Jid to) {
        this.to = to;
    }

    @Override
    public final synchronized Locale getLanguage() {
        return this.lang;
    }

    public final synchronized void setLanguage(Locale language) {
        this.lang = language;
    }

    public final <T> T getExtension(Class<T> clazz) {
        for (Object extension : this.extensions) {
            if (!clazz.isAssignableFrom(extension.getClass())) continue;
            return (T)extension;
        }
        return null;
    }

    public final boolean hasExtension(Class<?> clazz) {
        return this.getExtension(clazz) != null;
    }

    public final synchronized StanzaError getError() {
        return this.error;
    }

    public final synchronized void setError(StanzaError stanzaError) {
        this.error = stanzaError;
    }

    public abstract Stanza createError(StanzaError var1);

    public abstract Stanza createError(Condition var1);

    public static boolean isToItselfOrServer(Stanza stanza, CharSequence domain, Jid connectedResource) {
        if (stanza instanceof Presence && stanza.getTo() == null) {
            return false;
        }
        if (stanza.getTo() == null) {
            return true;
        }
        Jid toBare = stanza.getTo().asBareJid();
        return connectedResource != null && toBare.equals(connectedResource.asBareJid()) || domain != null && (toBare.equals(Jid.ofDomain((CharSequence)domain)) || toBare.toString().endsWith("." + domain));
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.id != null) {
            sb.append(" (").append(this.id).append(')');
        }
        if (this.from != null) {
            sb.append(" from '").append((CharSequence)this.from).append('\'');
        }
        if (this.to != null) {
            sb.append(" to '").append((CharSequence)this.to).append('\'');
        }
        if (!this.extensions.isEmpty()) {
            sb.append("\nExtension(s):\n");
            for (Object o : this.extensions) {
                sb.append(o).append('\n');
            }
        }
        if (this.error != null) {
            sb.append('\n').append("Error: ").append(this.error);
        }
        return sb.toString();
    }
}

