/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stream.model;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.core.session.model.SessionClose;
import rocks.xmpp.core.session.model.SessionOpen;
import rocks.xmpp.core.stream.model.StreamElement;

public final class StreamHeader
implements SessionOpen,
CharSequence {
    public static final String STREAM_NAMESPACE = "http://etherx.jabber.org/streams";
    public static final String STREAM_NAMESPACE_PREFIX = "stream";
    public static final String LOCAL_NAME = "stream";
    public static final StreamElement CLOSING_STREAM_TAG = new SessionClose(){

        public String toString() {
            return "</stream:stream>";
        }
    };
    private final Jid from;
    private final Jid to;
    private final String id;
    private final String version;
    private final Locale lang;
    private final String contentNamespace;
    private final List<QName> additionalNamespaces = new ArrayList<QName>();

    private StreamHeader(Jid from, Jid to, String id, String version, Locale lang, String contentNamespace, QName ... additionalNamespaces) {
        this.from = from;
        this.to = to;
        this.id = id;
        this.version = version;
        this.lang = lang;
        this.contentNamespace = contentNamespace;
        if (additionalNamespaces.length > 0) {
            HashSet<String> prefixes = new HashSet<String>();
            HashSet<String> namespaces = new HashSet<String>();
            for (QName additionalNamespace : additionalNamespaces) {
                if (additionalNamespace.getNamespaceURI() == null || "".equals(additionalNamespace.getNamespaceURI()) || additionalNamespace.getPrefix() == null || "".equals(additionalNamespace.getPrefix())) {
                    throw new IllegalArgumentException("Namespace URI and prefix must not be empty.");
                }
                if (!prefixes.add(additionalNamespace.getPrefix())) {
                    throw new IllegalArgumentException("Duplicate prefix " + additionalNamespace.getPrefix());
                }
                if (!namespaces.add(additionalNamespace.getNamespaceURI())) {
                    throw new IllegalArgumentException("Duplicate namespace " + additionalNamespace.getNamespaceURI());
                }
                this.additionalNamespaces.add(additionalNamespace);
            }
        }
    }

    public static StreamHeader create(Jid from, Jid to, String id, String version, Locale lang, String contentNamespace, QName ... additionalNamespaces) {
        return new StreamHeader(from, to, id, version, lang, contentNamespace, additionalNamespaces);
    }

    public static StreamHeader initialClientToServer(Jid from, Jid to, Locale lang, QName ... additionalNamespaces) {
        return StreamHeader.initialClientToServer(from, to, lang, "jabber:client", additionalNamespaces);
    }

    public static StreamHeader initialClientToServer(Jid from, Jid to, Locale lang, String contentNamespace, QName ... additionalNamespaces) {
        return new StreamHeader(from, Objects.requireNonNull(to).asBareJid().withLocal(null), null, "1.0", lang, contentNamespace, additionalNamespaces);
    }

    public static StreamHeader responseClientToServer(Jid from, Jid to, String id, Locale lang, QName ... additionalNamespaces) {
        return new StreamHeader(Objects.requireNonNull(from).asBareJid().withLocal(null), to != null ? to.asBareJid() : null, Objects.requireNonNull(id), "1.0", Objects.requireNonNull(lang), "jabber:client", additionalNamespaces);
    }

    public static StreamHeader initialServerToServer(Jid from, Jid to, Locale lang, QName ... additionalNamespaces) {
        return new StreamHeader(from, Objects.requireNonNull(to).asBareJid().withLocal(null), null, "1.0", lang, "jabber:server", additionalNamespaces);
    }

    public static StreamHeader responseServerToServer(Jid from, Jid to, String id, Locale lang, QName ... additionalNamespaces) {
        return new StreamHeader(Objects.requireNonNull(from).asBareJid().withLocal(null), Objects.requireNonNull(to).asBareJid().withLocal(null), Objects.requireNonNull(id), "1.0", Objects.requireNonNull(lang), "jabber:server", additionalNamespaces);
    }

    public final void writeTo(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartDocument(StandardCharsets.UTF_8.name(), "1.0");
        writer.writeStartElement("stream", "stream", STREAM_NAMESPACE);
        writer.writeNamespace("", this.contentNamespace);
        writer.writeNamespace("stream", STREAM_NAMESPACE);
        for (QName qName : this.additionalNamespaces) {
            writer.writeNamespace(qName.getPrefix(), qName.getNamespaceURI());
        }
        if (this.from != null) {
            writer.writeAttribute("from", this.from.toString());
        }
        if (this.to != null) {
            writer.writeAttribute("to", this.to.toString());
        }
        if (this.id != null) {
            writer.writeAttribute("id", this.id);
        }
        if (this.version != null) {
            writer.writeAttribute("version", this.version);
        }
        if (this.lang != null) {
            writer.writeAttribute("xml", "http://www.w3.org/XML/1998/namespace", "lang", this.lang.toLanguageTag());
        }
        writer.writeCharacters("");
        writer.flush();
    }

    @Override
    public final Jid getFrom() {
        return this.from;
    }

    @Override
    public final Jid getTo() {
        return this.to;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final Locale getLanguage() {
        return this.lang;
    }

    @Override
    public final String getVersion() {
        return this.version;
    }

    public final String getContentNamespace() {
        return this.contentNamespace;
    }

    public final List<QName> getAdditionalNamespaces() {
        return Collections.unmodifiableList(this.additionalNamespaces);
    }

    @Override
    public final int length() {
        return this.toString().length();
    }

    @Override
    public final char charAt(int i) {
        return this.toString().charAt(i);
    }

    @Override
    public final CharSequence subSequence(int i, int i1) {
        return this.toString().subSequence(i, i1);
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder("<?xml version='1.0' encoding='UTF-8'?><").append("stream").append(':').append("stream").append(" xmlns=\"").append(this.contentNamespace).append("\" xmlns:").append("stream").append("=\"").append(STREAM_NAMESPACE).append('\"');
        for (QName qName : this.additionalNamespaces) {
            sb.append(" xmlns:").append(qName.getPrefix()).append("=\"").append(qName.getNamespaceURI()).append('\"');
        }
        if (this.from != null) {
            sb.append(" from=\"").append((CharSequence)this.from).append('\"');
        }
        if (this.to != null) {
            sb.append(" to=\"").append((CharSequence)this.to).append('\"');
        }
        if (this.id != null) {
            sb.append(" id=\"").append(this.id).append('\"');
        }
        if (this.version != null) {
            sb.append(" version=\"").append(this.version).append('\"');
        }
        if (this.lang != null) {
            sb.append(" xml:lang=\"").append(this.lang.toLanguageTag()).append('\"');
        }
        sb.append('>');
        return sb.toString();
    }
}

