/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.caps2.model;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import rocks.xmpp.core.stream.model.StreamFeature;
import rocks.xmpp.extensions.caps.model.EntityCapabilities;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.disco.model.info.DiscoverableInfo;
import rocks.xmpp.extensions.disco.model.info.Identity;
import rocks.xmpp.extensions.hashes.model.Hash;
import rocks.xmpp.extensions.hashes.model.Hashed;
import rocks.xmpp.util.Strings;

@XmlRootElement(name="c")
public final class EntityCapabilities2
extends StreamFeature
implements EntityCapabilities {
    public static final String NAMESPACE = "urn:xmpp:caps";
    @XmlElementRef
    private final Set<Hash> hashes = new LinkedHashSet<Hash>();

    private EntityCapabilities2() {
    }

    public EntityCapabilities2(DiscoverableInfo discoverableInfo, MessageDigest ... messageDigest) {
        if (messageDigest.length == 0) {
            throw new IllegalArgumentException("At least one hash function must be provided.");
        }
        byte[] verificationString = this.createVerificationString(discoverableInfo);
        for (MessageDigest digest : messageDigest) {
            this.hashes.add(new Hash(digest.digest(verificationString), digest.getAlgorithm()));
        }
    }

    @Override
    public final Set<Hashed> getCapabilityHashSet() {
        return Collections.unmodifiableSet(this.hashes);
    }

    @Override
    public final byte[] createVerificationString(DiscoverableInfo discoverableInfo) {
        StringBuilder sb = new StringBuilder();
        for (String feature : discoverableInfo.getFeatures()) {
            sb.append(feature).appendCodePoint(31);
        }
        sb.appendCodePoint(28);
        for (Identity identity : discoverableInfo.getIdentities()) {
            if (identity.getCategory() != null) {
                sb.append(identity.getCategory());
            }
            sb.appendCodePoint(31);
            if (identity.getType() != null) {
                sb.append(identity.getType());
            }
            sb.appendCodePoint(31);
            if (identity.getLanguage() != null) {
                sb.append(identity.getLanguage().toLanguageTag());
            }
            sb.appendCodePoint(31);
            if (identity.getName() != null) {
                sb.append(identity.getName());
            }
            sb.appendCodePoint(31);
            sb.appendCodePoint(30);
        }
        sb.appendCodePoint(28);
        for (DataForm dataForm : discoverableInfo.getExtensions()) {
            ArrayList<DataForm.Field> fields = new ArrayList<DataForm.Field>(dataForm.getFields());
            fields.sort(null);
            for (DataForm.Field field : fields) {
                if (field.getName() != null) {
                    sb.append(field.getName());
                }
                sb.appendCodePoint(31);
                if (field.getValue() != null) {
                    ArrayList<String> values = new ArrayList<String>(field.getValues());
                    values.sort((s, t1) -> Strings.compareUnsignedBytes(s, t1, StandardCharsets.UTF_8));
                    for (String value : values) {
                        sb.append(value);
                        sb.appendCodePoint(31);
                    }
                }
                sb.appendCodePoint(30);
            }
            sb.appendCodePoint(29);
        }
        sb.appendCodePoint(28);
        return sb.toString().getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public final String createCapabilityHashNode(Hashed hashed) {
        return "urn:xmpp:caps#" + hashed.getHashAlgorithm() + "." + Base64.getEncoder().encodeToString(hashed.getHashValue());
    }

    public final String toString() {
        return "Caps 2.0: " + this.hashes;
    }
}

