/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.rsm;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import rocks.xmpp.extensions.rsm.ResultSetProvider;
import rocks.xmpp.extensions.rsm.model.ResultSetItem;

final class CollectionBasedItemProvider<T extends ResultSetItem>
implements ResultSetProvider<T> {
    private final Collection<T> items;

    CollectionBasedItemProvider(Collection<T> items) {
        this.items = Objects.requireNonNull(items);
    }

    @Override
    public final int getItemCount() {
        return this.items.size();
    }

    @Override
    public final List<T> getItems() {
        return List.copyOf(this.items);
    }

    @Override
    public final List<T> getItems(int index, int maxSize) {
        List<T> list = this.getItems();
        int toIndex = Math.min(index + maxSize, list.size());
        if (index > toIndex) {
            return Collections.emptyList();
        }
        return list.subList(Math.max(0, index), toIndex);
    }

    @Override
    public final List<T> getItemsAfter(String itemId, int maxSize) {
        return this.getItems(this.indexOf(itemId) + 1, maxSize);
    }

    @Override
    public final List<T> getItemsBefore(String itemId, int maxSize) {
        return this.getItems(this.indexOf(itemId) - maxSize, maxSize);
    }

    @Override
    public final int indexOf(String itemId) {
        Objects.requireNonNull(itemId);
        ListIterator<T> itemIterator = this.getItems().listIterator();
        while (itemIterator.hasNext()) {
            ResultSetItem item = (ResultSetItem)itemIterator.next();
            if (item == null || !itemId.equals(item.getId())) continue;
            return itemIterator.previousIndex();
        }
        return -1;
    }
}

