/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.rsm;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import rocks.xmpp.extensions.rsm.ResultSetProvider;
import rocks.xmpp.extensions.rsm.model.ResultSetItem;

final class CombinedResultSetProvider<T extends ResultSetItem>
implements ResultSetProvider<T> {
    private final Iterable<ResultSetProvider<T>> resultSetProviders;

    CombinedResultSetProvider(Iterable<ResultSetProvider<T>> resultSetProviders) {
        this.resultSetProviders = resultSetProviders;
    }

    @Override
    public final int getItemCount() {
        return StreamSupport.stream(this.resultSetProviders.spliterator(), false).flatMapToInt(resultSetProvider -> IntStream.of(resultSetProvider.getItemCount())).sum();
    }

    @Override
    public final List<T> getItems() {
        return StreamSupport.stream(this.resultSetProviders.spliterator(), false).flatMap(resultSetProvider -> resultSetProvider.getItems().stream()).collect(Collectors.toList());
    }

    @Override
    public final List<T> getItems(int index, int maxSize) {
        ArrayList<T> items = new ArrayList<T>();
        int currentCount = 0;
        int i = index;
        for (ResultSetProvider<T> resultSetProvider : this.resultSetProviders) {
            int count = resultSetProvider.getItemCount();
            int size = items.size();
            if (index < (currentCount += count)) {
                if (maxSize > size) {
                    items.addAll(resultSetProvider.getItems(i, maxSize - size));
                }
                if (items.size() >= maxSize) break;
                i = 0;
                continue;
            }
            i = index - currentCount;
        }
        return items;
    }

    @Override
    public final List<T> getItemsAfter(String itemId, int maxSize) {
        return this.getItems(this.indexOf(itemId) + 1, maxSize);
    }

    @Override
    public final List<T> getItemsBefore(String itemId, int maxSize) {
        return this.getItems(this.indexOf(itemId) - maxSize, maxSize);
    }

    @Override
    public final int indexOf(String itemId) {
        int count = 0;
        for (ResultSetProvider<T> resultSetProvider : this.resultSetProviders) {
            int index = resultSetProvider.indexOf(itemId);
            if (index > -1) {
                return index + count;
            }
            count += resultSetProvider.getItemCount();
        }
        return -1;
    }
}

