/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.util;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

final class BranchedReader
extends FilterReader {
    private final Writer branch;

    BranchedReader(Reader in, Writer branch) {
        super(in);
        this.branch = branch;
    }

    @Override
    public int read() throws IOException {
        int c = super.read();
        if (c != -1) {
            this.branch.write(c);
        }
        return c;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        int n = super.read(cbuf);
        if (n != -1) {
            this.branch.write(cbuf, 0, n);
        }
        return n;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int n = super.read(cbuf, off, len);
        if (n != -1) {
            this.branch.write(cbuf, off, n);
        }
        return n;
    }
}

