/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.util;

import java.io.OutputStream;
import java.nio.ByteBuffer;

final class ByteBufferOutputStream
extends OutputStream {
    private ByteBuffer buffer;

    ByteBufferOutputStream(int size, boolean direct) {
        this.buffer = direct ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
    }

    @Override
    public final void write(int b) {
        if (!this.buffer.hasRemaining()) {
            this.ensureCapacity(this.buffer.limit() + 1);
        }
        this.buffer.put((byte)b);
    }

    @Override
    public final void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.buffer.position() + len);
        this.buffer.put(b, off, len);
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity - this.buffer.limit() > 0) {
            int newCapacity = this.buffer.limit() << 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            ByteBuffer newBuffer = this.buffer.isDirect() ? ByteBuffer.allocateDirect(newCapacity) : ByteBuffer.allocate(newCapacity);
            this.buffer.flip();
            newBuffer.put(this.buffer);
            this.buffer = newBuffer;
        }
    }

    final ByteBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public final void close() {
        this.buffer = null;
    }
}

