/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.EventObject;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamWriter;
import rocks.xmpp.core.XmppContext;
import rocks.xmpp.util.BranchedInputStream;
import rocks.xmpp.util.BranchedOutputStream;
import rocks.xmpp.util.BranchedReader;
import rocks.xmpp.util.BranchedWriter;
import rocks.xmpp.util.PrefixFreeCanonicalizationWriter;

public final class XmppUtils {
    private static final System.Logger logger = System.getLogger(XmppUtils.class.getName());

    private XmppUtils() {
    }

    public static XMLStreamWriter createXmppStreamWriter(XMLStreamWriter xmlStreamWriter, boolean writeStreamNamepace) {
        return new PrefixFreeCanonicalizationWriter(xmlStreamWriter, writeStreamNamepace);
    }

    public static XMLStreamWriter createXmppStreamWriter(XMLStreamWriter xmlStreamWriter) {
        return XmppUtils.createXmppStreamWriter(xmlStreamWriter, false);
    }

    public static InputStream createBranchedInputStream(InputStream source, OutputStream target) {
        return new BranchedInputStream(source, target);
    }

    public static OutputStream createBranchedOutputStream(OutputStream out, OutputStream branch) {
        return new BranchedOutputStream(out, branch);
    }

    public static Reader newBranchedReader(Reader reader, Writer branch) {
        return new BranchedReader(reader, branch);
    }

    public static Writer newBranchedWriter(Writer writer, Writer branch) {
        return new BranchedWriter(writer, branch);
    }

    public static String hash(byte[] bytes) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.reset();
            return DatatypeConverter.printHexBinary((byte[])messageDigest.digest(bytes)).toLowerCase();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static ThreadFactory createNamedThreadFactory(String threadName) {
        return new DefaultThreadFactory(threadName);
    }

    public static <T extends EventObject> void notifyEventListeners(Iterable<Consumer<T>> eventListeners, T e) {
        eventListeners.forEach(listener -> {
            try {
                listener.accept(e);
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.WARNING, ex.getMessage(), (Throwable)ex);
            }
        });
    }

    public static JAXBContext createContext(Iterable<Class<?>> additionalClasses) {
        ServiceLoader<XmppContext> loader = ServiceLoader.load(XmppContext.class);
        HashSet classes = new HashSet();
        for (XmppContext module : loader) {
            module.getClasses().forEach(classes::add);
        }
        additionalClasses.forEach(classes::add);
        try {
            return JAXBContext.newInstance((Class[])classes.toArray(new Class[0]));
        }
        catch (JAXBException e) {
            throw new DataBindingException((Throwable)e);
        }
    }

    private static final class DefaultThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String name;

        DefaultThreadFactory(String threadName) {
            this.name = "XMPP.rocks - " + threadName + " (";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, this.name + this.threadNumber.getAndIncrement() + ")");
            thread.setDaemon(true);
            return thread;
        }
    }
}

