/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2014-2018 Christian Schudt
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package rocks.xmpp.core.net;

import java.util.function.Consumer;

import rocks.xmpp.core.stream.StreamHandler;

/**
 * Defines characteristics of a TCP binding, like stream encryption via TLS and stream compression.
 *
 * @author Christian Schudt
 */
public abstract class TcpConnection extends AbstractConnection {

    protected TcpConnection(ConnectionConfiguration connectionConfiguration,
                            StreamHandler streamHandler,
                            Consumer<Throwable> onException) {
        super(connectionConfiguration, streamHandler, onException);
    }

    /**
     * Secures the connection with TLS.
     *
     * @throws Exception Any exception which may occur during TLS handshake.
     */
    public abstract void secureConnection() throws Exception;

    /**
     * Compresses the connection.
     *
     * @param method    The compression method.
     * @param onSuccess Invoked after the compression method has been chosen, but before compression is applied.
     * @throws Exception Any exception which may occur during compression.
     */
    public abstract void compressConnection(final String method, final Runnable onSuccess) throws Exception;
}
