/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core;

import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import rocks.xmpp.core.LanguageElement;
import rocks.xmpp.util.adapters.LocaleAdapter;

public final class Text
implements LanguageElement,
CharSequence,
Comparable<Text> {
    private static final Comparator<Text> COMPARATOR = Comparator.nullsLast((o1, o2) -> {
        Collator collator = o1.getLanguage() != null ? Collator.getInstance(o1.getLanguage()) : Collator.getInstance();
        return collator.compare(o1.getText(), o2.getText());
    }).thenComparing(Text::getLanguage, Comparator.nullsFirst(Comparator.comparing(Locale::toLanguageTag)));
    @XmlJavaTypeAdapter(value=LocaleAdapter.class)
    @XmlAttribute(namespace="http://www.w3.org/XML/1998/namespace")
    private final Locale lang;
    @XmlValue
    private final String text;

    private Text() {
        this.text = null;
        this.lang = null;
    }

    public Text(String text) {
        this(text, null);
    }

    public Text(String text, Locale language) {
        this.text = Objects.requireNonNull(text);
        this.lang = language;
    }

    @Override
    public final Locale getLanguage() {
        return this.lang;
    }

    public final String getText() {
        return this.text;
    }

    @Override
    public final int length() {
        return this.toString().length();
    }

    @Override
    public final char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public final CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    public final int compareTo(Text o) {
        return COMPARATOR.compare(this, o);
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Text)) {
            return false;
        }
        Text other = (Text)o;
        return Objects.equals(this.text, other.getText()) && Objects.equals(this.lang, other.getLanguage());
    }

    public final int hashCode() {
        return Objects.hash(this.text, this.lang);
    }

    @Override
    public final String toString() {
        return this.text;
    }
}

