/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.net;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import rocks.xmpp.core.XmppException;
import rocks.xmpp.core.net.Connection;
import rocks.xmpp.core.net.ConnectionConfiguration;
import rocks.xmpp.core.session.model.SessionClose;
import rocks.xmpp.core.session.model.SessionOpen;
import rocks.xmpp.core.stream.StreamHandler;
import rocks.xmpp.core.stream.model.StreamError;
import rocks.xmpp.util.concurrent.CompletionStages;

public abstract class AbstractConnection
implements Connection,
StreamHandler {
    private final AtomicBoolean closed = new AtomicBoolean();
    private final CompletableFuture<Void> closedByPeer = new CompletableFuture();
    private final ConnectionConfiguration connectionConfiguration;
    private final StreamHandler streamHandler;
    private final Consumer<Throwable> onException;
    private String streamId;

    protected AbstractConnection(ConnectionConfiguration connectionConfiguration, StreamHandler streamHandler, Consumer<Throwable> onException) {
        this.connectionConfiguration = connectionConfiguration;
        this.streamHandler = streamHandler;
        this.onException = onException;
    }

    @Override
    public final ConnectionConfiguration getConfiguration() {
        return this.connectionConfiguration;
    }

    @Override
    public boolean isUsingAcknowledgements() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleElement(Object streamElement) {
        if (streamElement instanceof SessionOpen) {
            AbstractConnection abstractConnection = this;
            synchronized (abstractConnection) {
                this.streamId = ((SessionOpen)streamElement).getId();
            }
        } else if (streamElement instanceof SessionClose) {
            this.closedByPeer.complete(null);
            this.closeAsync();
        }
        try {
            if (this.streamHandler.handleElement(streamElement)) {
                this.restartStream();
                return true;
            }
        }
        catch (XmppException e) {
            this.onException.accept(e);
        }
        return false;
    }

    protected abstract void restartStream();

    protected abstract CompletionStage<Void> closeStream();

    protected abstract CompletionStage<Void> closeConnection();

    @Override
    public final synchronized String getStreamId() {
        return this.streamId;
    }

    @Override
    public final CompletionStage<Void> closeAsync() {
        if (this.closed.compareAndSet(false, true)) {
            return this.closeStream().thenCompose(v -> this.closedByPeer.applyToEither(CompletionStages.timeoutAfter(500L, TimeUnit.MILLISECONDS), Function.identity())).handle((aVoid, exc) -> this.closeConnection()).thenCompose(Function.identity());
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public final CompletionStage<Void> closeAsync(StreamError streamError) {
        this.write(streamError);
        return this.closeAsync();
    }

    @Override
    public final void close() throws Exception {
        try {
            this.closeAsync().toCompletableFuture().get(2L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public final boolean isClosed() {
        return this.closed.get();
    }
}

