/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stream.model;

import java.util.Locale;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import rocks.xmpp.core.LanguageElement;
import rocks.xmpp.core.Text;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.core.stream.model.errors.Condition;

@XmlRootElement(name="error")
public final class StreamError
implements StreamElement,
LanguageElement {
    @XmlElementRef
    private final Condition condition;
    @XmlElement(namespace="urn:ietf:params:xml:ns:xmpp-streams")
    private final Text text;
    @XmlAnyElement(lax=true)
    private final Object extension;

    private StreamError() {
        this.condition = null;
        this.text = null;
        this.extension = null;
    }

    public StreamError(Condition condition) {
        this(condition, null, null, null);
    }

    public StreamError(Condition condition, String text, Locale language) {
        this(condition, text, language, null);
    }

    public StreamError(Condition condition, Object extension) {
        this(condition, null, null, extension);
    }

    public StreamError(Condition condition, String text, Locale language, Object extension) {
        this.condition = Objects.requireNonNull(condition);
        this.text = text != null ? new Text(text, language) : null;
        this.extension = extension;
    }

    @Override
    public final Locale getLanguage() {
        if (this.text != null) {
            return this.text.getLanguage();
        }
        return null;
    }

    public final String getText() {
        if (this.text != null) {
            return this.text.getText();
        }
        return null;
    }

    public final Object getExtension() {
        return this.extension;
    }

    public final Condition getCondition() {
        if (this.condition != null) {
            return this.condition;
        }
        return Condition.UNDEFINED_CONDITION;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.condition);
        if (this.text != null) {
            sb.append("\n        ").append(this.text);
        }
        if (this.extension != null) {
            sb.append("\n        ").append(this.extension);
        }
        return sb.toString();
    }
}

