/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.data.mediaelement.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;

@XmlRootElement
public final class Media {
    public static final String NAMESPACE = "urn:xmpp:media-element";
    private final List<Location> uri = new ArrayList<Location>();
    @XmlAttribute
    private final int height;
    @XmlAttribute
    private final int width;

    private Media() {
        this.height = 0;
        this.width = 0;
    }

    public Media(Location ... locations) {
        this.uri.addAll(Arrays.asList(locations));
        this.height = 0;
        this.width = 0;
    }

    public Media(int width, int height, Location ... locations) {
        this.width = width;
        this.height = height;
        this.uri.addAll(Arrays.asList(locations));
    }

    public final List<Location> getLocations() {
        return Collections.unmodifiableList(this.uri);
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getWidth() {
        return this.width;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Media)) {
            return false;
        }
        Media other = (Media)o;
        return this.height == other.height && this.width == other.width && this.uri.equals(other.uri);
    }

    public final int hashCode() {
        return Objects.hash(this.height, this.width, this.uri);
    }

    public static final class Location {
        @XmlValue
        private final URI uri;
        @XmlAttribute
        private final String type;

        public Location(String type, URI uri) {
            this.type = Objects.requireNonNull(type);
            this.uri = Objects.requireNonNull(uri);
        }

        private Location() {
            this.type = null;
            this.uri = null;
        }

        public final URI getUri() {
            return this.uri;
        }

        public final String getType() {
            return this.type;
        }

        public final boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Location)) {
                return false;
            }
            Location other = (Location)o;
            return Objects.equals(this.uri, other.uri) && Objects.equals(this.type, other.type);
        }

        public final int hashCode() {
            return Objects.hash(this.uri, this.type);
        }
    }
}

