/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.im.roster.model;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import rocks.xmpp.addr.Jid;
import rocks.xmpp.im.roster.model.RosterItem;
import rocks.xmpp.im.roster.model.SubscriptionState;

public final class Contact
implements RosterItem,
Comparable<Contact> {
    @XmlAttribute
    private final Boolean approved;
    @XmlJavaTypeAdapter(value=PendingAdapter.class)
    @XmlAttribute
    private final Boolean ask;
    private final List<String> group = new ArrayList<String>();
    @XmlAttribute
    private final Jid jid;
    @XmlAttribute
    private final String name;
    @XmlAttribute
    private final SubscriptionState.Subscription subscription;

    private Contact() {
        this.jid = null;
        this.name = null;
        this.ask = null;
        this.subscription = null;
        this.approved = null;
    }

    public Contact(Jid jid) {
        this(jid, null);
    }

    public Contact(Jid jid, String name) {
        this(jid, name, Collections.emptyList());
    }

    public Contact(Jid jid, String name, String ... groups) {
        this(jid, name, Arrays.asList(groups));
    }

    public Contact(Jid jid, String name, Collection<String> groups) {
        this(jid, name, null, null, null, groups);
    }

    public Contact(RosterItem rosterItem) {
        this(rosterItem.getJid(), rosterItem.getName(), rosterItem.isPendingOut(), rosterItem.isApproved() ? Boolean.valueOf(true) : null, rosterItem.getSubscription(), rosterItem.getGroups());
    }

    public Contact(Jid jid, String name, Boolean isPending, Boolean approved, SubscriptionState.Subscription subscription, Collection<String> groups) {
        this.jid = Objects.requireNonNull(jid);
        this.name = name;
        this.ask = isPending;
        this.subscription = subscription;
        if (groups != null) {
            this.group.addAll(groups);
        }
        this.approved = approved;
    }

    public static Contact removeContact(Jid jid) {
        return new Contact(jid, null, null, null, SubscriptionState.Subscription.REMOVE, Collections.emptyList());
    }

    public Contact withName(String name) {
        return new Contact(this.jid, name, this.ask, this.approved, this.subscription, this.group);
    }

    public Contact withoutName() {
        return new Contact(this.jid, null, this.ask, this.approved, this.subscription, this.group);
    }

    public Contact withGroups(Collection<String> groups) {
        return new Contact(this.jid, this.name, this.ask, this.approved, this.subscription, groups);
    }

    public Contact withGroups(String ... groups) {
        return this.withGroups(groups != null ? Arrays.asList(groups) : null);
    }

    public Contact withoutGroups() {
        return this.withGroups(new String[0]);
    }

    @Override
    public final Jid getJid() {
        return this.jid;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final SubscriptionState.Subscription getSubscription() {
        return this.subscription;
    }

    @Override
    public final boolean isPendingOut() {
        return this.ask != null && this.ask != false;
    }

    @Override
    public final boolean isPendingIn() {
        return false;
    }

    @Override
    public final boolean isApproved() {
        return this.approved != null && this.approved != false;
    }

    @Override
    public final List<String> getGroups() {
        return Collections.unmodifiableList(this.group);
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Contact)) {
            return false;
        }
        Contact other = (Contact)o;
        return Objects.equals(this.jid, other.jid) && Objects.equals(this.name, other.name) && Objects.equals((Object)this.subscription, (Object)other.subscription) && Objects.equals(this.approved, other.approved) && Objects.equals(this.ask, other.ask) && this.group.size() == other.group.size() && this.group.containsAll(other.group);
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.jid, this.name, this.subscription, this.approved, this.ask, this.group});
    }

    @Override
    public final int compareTo(Contact o) {
        if (this == o) {
            return 0;
        }
        if (o != null) {
            int result = this.name != null ? (o.name != null ? Collator.getInstance().compare(this.name, o.name) : -1) : (o.name != null ? 1 : 0);
            if (result == 0) {
                result = this.subscription != null ? (o.subscription != null ? this.subscription.compareTo(o.subscription) : -1) : (o.subscription != null ? 1 : 0);
            }
            if (result == 0) {
                return Boolean.compare(this.isPendingOut(), o.isPendingOut());
            }
            return result;
        }
        return -1;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(this.jid.toString());
        if (this.name != null) {
            sb.append(" (").append(this.name).append(')');
        }
        return sb.toString();
    }

    private static final class PendingAdapter
    extends XmlAdapter<Ask, Boolean> {
        private PendingAdapter() {
        }

        public Boolean unmarshal(Ask v) {
            return v == Ask.SUBSCRIBE;
        }

        public Ask marshal(Boolean v) {
            return v != null && v != false ? Ask.SUBSCRIBE : null;
        }
    }

    @XmlEnum
    private static enum Ask {
        SUBSCRIBE;

    }
}

