/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.im.roster.model;

import rocks.xmpp.core.stanza.model.Presence;
import rocks.xmpp.im.roster.model.SubscriptionState;

public enum DefinedState implements SubscriptionState
{
    NONE(SubscriptionState.Subscription.NONE, false, false),
    NONE_PENDING_OUT(SubscriptionState.Subscription.NONE, true, false),
    NONE_PENDING_IN(SubscriptionState.Subscription.NONE, false, true),
    NONE_PENDING_OUT_IN(SubscriptionState.Subscription.NONE, true, true),
    TO(SubscriptionState.Subscription.TO, false, false),
    TO_PENDING_IN(SubscriptionState.Subscription.TO, false, true),
    FROM(SubscriptionState.Subscription.FROM, false, false),
    FROM_PENDING_OUT(SubscriptionState.Subscription.FROM, true, false),
    BOTH(SubscriptionState.Subscription.BOTH, false, false);

    private final SubscriptionState.Subscription subscription;
    private final boolean pendingOut;
    private final boolean pendingIn;

    private DefinedState(SubscriptionState.Subscription subscription, boolean pendingOut, boolean pendingIn) {
        this.subscription = subscription;
        this.pendingOut = pendingOut;
        this.pendingIn = pendingIn;
    }

    public static DefinedState valueOf(SubscriptionState subscriptionState) {
        if (subscriptionState == null || subscriptionState.getSubscription() == null) {
            return NONE;
        }
        switch (subscriptionState.getSubscription()) {
            case NONE: {
                if (subscriptionState.isPendingOut()) {
                    if (subscriptionState.isPendingIn()) {
                        return NONE_PENDING_OUT_IN;
                    }
                    return NONE_PENDING_OUT;
                }
                if (subscriptionState.isPendingIn()) {
                    return NONE_PENDING_IN;
                }
                return NONE;
            }
            case TO: {
                if (subscriptionState.isPendingIn()) {
                    return TO_PENDING_IN;
                }
                return TO;
            }
            case FROM: {
                if (subscriptionState.isPendingOut()) {
                    return FROM_PENDING_OUT;
                }
                return FROM;
            }
            case BOTH: {
                return BOTH;
            }
        }
        return NONE;
    }

    @Override
    public final SubscriptionState.Subscription getSubscription() {
        return this.subscription;
    }

    @Override
    public final boolean isPendingOut() {
        return this.pendingOut;
    }

    @Override
    public final boolean isPendingIn() {
        return this.pendingIn;
    }

    public final DefinedState onOutboundSubscriptionChange(Presence.Type type) {
        switch (type) {
            case SUBSCRIBE: {
                switch (this) {
                    case NONE: {
                        return NONE_PENDING_OUT;
                    }
                    case NONE_PENDING_IN: {
                        return NONE_PENDING_OUT_IN;
                    }
                    case FROM: {
                        return FROM_PENDING_OUT;
                    }
                }
                return this;
            }
            case UNSUBSCRIBE: {
                switch (this) {
                    case NONE_PENDING_OUT: 
                    case TO: {
                        return NONE;
                    }
                    case NONE_PENDING_OUT_IN: 
                    case TO_PENDING_IN: {
                        return NONE_PENDING_IN;
                    }
                    case FROM_PENDING_OUT: 
                    case BOTH: {
                        return FROM;
                    }
                }
                return this;
            }
            case SUBSCRIBED: {
                switch (this) {
                    case NONE_PENDING_IN: {
                        return FROM;
                    }
                    case NONE_PENDING_OUT_IN: {
                        return FROM_PENDING_OUT;
                    }
                    case TO_PENDING_IN: {
                        return BOTH;
                    }
                }
                return this;
            }
            case UNSUBSCRIBED: {
                switch (this) {
                    case NONE_PENDING_IN: 
                    case FROM: {
                        return NONE;
                    }
                    case NONE_PENDING_OUT_IN: 
                    case FROM_PENDING_OUT: {
                        return NONE_PENDING_OUT;
                    }
                    case TO_PENDING_IN: 
                    case BOTH: {
                        return TO;
                    }
                }
                return this;
            }
        }
        throw new IllegalArgumentException("Only subscription related presence types allowed.");
    }

    public final DefinedState onInboundSubscriptionChange(Presence.Type type) {
        switch (type) {
            case SUBSCRIBE: {
                switch (this) {
                    case NONE: {
                        return NONE_PENDING_IN;
                    }
                    case NONE_PENDING_OUT: {
                        return NONE_PENDING_OUT_IN;
                    }
                    case TO: {
                        return TO_PENDING_IN;
                    }
                }
                return this;
            }
            case UNSUBSCRIBE: {
                switch (this) {
                    case NONE_PENDING_IN: 
                    case FROM: {
                        return NONE;
                    }
                    case NONE_PENDING_OUT_IN: 
                    case FROM_PENDING_OUT: {
                        return NONE_PENDING_OUT;
                    }
                    case TO_PENDING_IN: 
                    case BOTH: {
                        return TO;
                    }
                }
                return this;
            }
            case SUBSCRIBED: {
                switch (this) {
                    case NONE_PENDING_OUT: {
                        return TO;
                    }
                    case NONE_PENDING_OUT_IN: {
                        return TO_PENDING_IN;
                    }
                    case FROM_PENDING_OUT: {
                        return BOTH;
                    }
                }
                return this;
            }
            case UNSUBSCRIBED: {
                switch (this) {
                    case NONE_PENDING_OUT: 
                    case TO: {
                        return NONE;
                    }
                    case NONE_PENDING_OUT_IN: 
                    case TO_PENDING_IN: {
                        return NONE_PENDING_IN;
                    }
                    case FROM_PENDING_OUT: 
                    case BOTH: {
                        return FROM;
                    }
                }
                return this;
            }
        }
        throw new IllegalArgumentException("Only subscription related presence types allowed.");
    }
}

