/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stream.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import rocks.xmpp.core.stream.StreamNegotiationResult;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.core.stream.model.StreamFeature;
import rocks.xmpp.core.stream.server.ServerStreamFeatureNegotiator;

public final class ServerStreamFeaturesManager {
    private final Map<ServerStreamFeatureNegotiator<? extends StreamFeature>, StreamFeature> toBeNegotiated = new ConcurrentHashMap<ServerStreamFeatureNegotiator<? extends StreamFeature>, StreamFeature>();

    public final void registerStreamFeatureNegotiator(ServerStreamFeatureNegotiator<? extends StreamFeature> streamFeaturesNegotiator) {
        this.toBeNegotiated.put(streamFeaturesNegotiator, streamFeaturesNegotiator.createStreamFeature());
    }

    public final Collection<StreamFeature> getStreamFeatures() {
        ArrayList<StreamFeature> streamFeatures = new ArrayList<StreamFeature>(this.toBeNegotiated.values());
        streamFeatures.sort(null);
        int size = streamFeatures.size();
        for (int i = 0; i < size; ++i) {
            StreamFeature streamFeature = (StreamFeature)streamFeatures.get(i);
            if (!streamFeature.isMandatory() || !streamFeature.requiresRestart()) continue;
            for (int j = size - 1; j > i; --j) {
                streamFeatures.remove(j);
            }
            break;
        }
        return streamFeatures;
    }

    public final StreamNegotiationResult handleElement(StreamElement element) {
        for (ServerStreamFeatureNegotiator<? extends StreamFeature> streamNegotiator : this.toBeNegotiated.keySet()) {
            StreamNegotiationResult result = streamNegotiator.processNegotiation(element);
            switch (result) {
                case RESTART: 
                case SUCCESS: {
                    this.toBeNegotiated.remove(streamNegotiator);
                    return result;
                }
            }
        }
        return StreamNegotiationResult.IGNORE;
    }
}

