/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.extensions.compress.server;

import java.util.Arrays;
import rocks.xmpp.core.net.TcpConnection;
import rocks.xmpp.core.stream.StreamNegotiationResult;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.core.stream.model.StreamError;
import rocks.xmpp.core.stream.model.errors.Condition;
import rocks.xmpp.core.stream.server.StreamFeatureProvider;
import rocks.xmpp.extensions.compress.model.StreamCompression;
import rocks.xmpp.extensions.compress.model.feature.CompressionFeature;

public final class CompressionNegotiator
implements StreamFeatureProvider<CompressionFeature> {
    private final CompressionFeature feature;
    private final TcpConnection connection;

    public CompressionNegotiator(TcpConnection connection, String ... method) {
        this.connection = connection;
        this.feature = new CompressionFeature(Arrays.asList(method));
    }

    @Override
    public final CompressionFeature createStreamFeature() {
        return this.feature;
    }

    public final StreamNegotiationResult processNegotiation(Object element) {
        if (element instanceof StreamCompression.Compress) {
            StreamCompression.Compress compress = (StreamCompression.Compress)element;
            try {
                Runnable onSuccess = () -> this.connection.send((StreamElement)StreamCompression.COMPRESSED);
                this.connection.compressConnection(compress.getMethod(), onSuccess);
                return StreamNegotiationResult.RESTART;
            }
            catch (Exception e) {
                this.connection.closeAsync(new StreamError(Condition.UNDEFINED_CONDITION, (Object)new StreamCompression.Failure(StreamCompression.Failure.Condition.UNSUPPORTED_METHOD)));
            }
        }
        return StreamNegotiationResult.IGNORE;
    }
}

