/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stream.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import rocks.xmpp.core.stream.StreamNegotiationException;
import rocks.xmpp.core.stream.StreamNegotiationResult;
import rocks.xmpp.core.stream.model.StreamElement;
import rocks.xmpp.core.stream.model.StreamFeature;
import rocks.xmpp.core.stream.server.StreamFeatureProvider;

public final class ServerStreamFeaturesManager {
    private final Map<StreamFeatureProvider<? extends StreamFeature>, StreamFeature> toBeNegotiated = new ConcurrentHashMap<StreamFeatureProvider<? extends StreamFeature>, StreamFeature>();

    public final void registerStreamFeatureProvider(StreamFeatureProvider<? extends StreamFeature> streamFeatureProvider) {
        this.toBeNegotiated.put(streamFeatureProvider, streamFeatureProvider.createStreamFeature());
    }

    public final Collection<StreamFeature> getStreamFeatures() {
        ArrayList<StreamFeature> streamFeatures = new ArrayList<StreamFeature>(this.toBeNegotiated.values());
        streamFeatures.sort(null);
        int size = streamFeatures.size();
        for (int i = 0; i < size; ++i) {
            StreamFeature streamFeature = (StreamFeature)streamFeatures.get(i);
            if (!streamFeature.isMandatory() || !streamFeature.requiresRestart()) continue;
            if (size <= i + 1) break;
            streamFeatures.subList(i + 1, size).clear();
            break;
        }
        return streamFeatures;
    }

    public final StreamNegotiationResult handleElement(StreamElement element) throws StreamNegotiationException {
        Iterator<StreamFeatureProvider<? extends StreamFeature>> streamNegotiators = this.toBeNegotiated.keySet().iterator();
        while (streamNegotiators.hasNext()) {
            StreamFeatureProvider<? extends StreamFeature> streamNegotiator = streamNegotiators.next();
            StreamNegotiationResult result = streamNegotiator.processNegotiation(element);
            switch (result) {
                case RESTART: 
                case SUCCESS: {
                    streamNegotiators.remove();
                    return result;
                }
            }
        }
        return StreamNegotiationResult.IGNORE;
    }
}

