/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stanza.model;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.stanza.model.Stanza;

@XmlTransient
public abstract class AbstractMessage
extends Stanza {
    @XmlElement(name="body")
    private final List<Body> body = new CopyOnWriteArrayList<Body>();
    @XmlElement(name="subject")
    private final List<Subject> subject = new CopyOnWriteArrayList<Subject>();
    @XmlAnyElement(lax=true)
    private final List<Object> extensions = new CopyOnWriteArrayList<Object>();
    @XmlAttribute
    private Type type;
    @XmlElement
    private Thread thread;

    protected AbstractMessage() {
    }

    protected AbstractMessage(Jid to) {
        this.to = to;
    }

    protected AbstractMessage(Jid to, Type type) {
        this.to = to;
        this.type = type;
    }

    protected AbstractMessage(Jid to, Type type, String body) {
        this.to = to;
        this.body.add(new Body(body));
        this.type = type;
    }

    public final List<Body> getBodies() {
        return this.body;
    }

    public final String getBody() {
        for (Body body : this.body) {
            if (body.getLanguage() != null && !body.getLanguage().isEmpty()) continue;
            return body.getText();
        }
        if (!this.body.isEmpty()) {
            return this.body.get(0).getText();
        }
        return null;
    }

    public final void setBody(String body) {
        if (body != null) {
            for (Body b : this.body) {
                if (b.getLanguage() != null && !b.getLanguage().isEmpty()) continue;
                b.setText(body);
                return;
            }
            this.body.add(new Body(body));
        } else {
            this.body.clear();
        }
    }

    public final List<Subject> getSubjects() {
        return this.subject;
    }

    public final String getSubject() {
        for (Subject subject : this.subject) {
            if (subject.getLanguage() != null && !subject.getLanguage().isEmpty()) continue;
            return subject.getText();
        }
        if (!this.subject.isEmpty()) {
            return this.subject.get(0).getText();
        }
        return null;
    }

    public final void setSubject(String subject) {
        if (subject != null) {
            for (Subject s : this.subject) {
                if (s.getLanguage() != null && !s.getLanguage().isEmpty()) continue;
                s.setText(subject);
                return;
            }
            this.subject.add(new Subject(subject));
        } else {
            this.subject.clear();
        }
    }

    public final Type getType() {
        return this.type;
    }

    public final void setType(Type type) {
        this.type = type;
    }

    public final String getThread() {
        if (this.thread != null) {
            return this.thread.value;
        }
        return null;
    }

    public final void setThread(String thread) {
        if (this.thread == null) {
            this.thread = new Thread();
        }
        this.thread.value = thread;
    }

    public final String getParentThread() {
        if (this.thread != null) {
            return this.thread.parent;
        }
        return null;
    }

    public final void setParentThread(String parent) {
        if (this.thread == null) {
            this.thread = new Thread();
        }
        this.thread.parent = parent;
    }

    public final List<Object> getExtensions() {
        return this.extensions;
    }

    @Override
    public final <T> T getExtension(Class<T> type) {
        for (Object extension : this.extensions) {
            if (extension.getClass() != type) continue;
            return (T)extension;
        }
        return null;
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.type != null) {
            String sType = this.type.name();
            sb.append(sType.substring(0, 1)).append(sType.substring(1).toLowerCase()).append(" ");
        }
        sb.append("Message");
        sb.append(super.toString());
        String body = this.getBody();
        if (body != null) {
            sb.append(": ").append(body);
        }
        return sb.toString();
    }

    private static final class Thread {
        @XmlAttribute(name="parent")
        private String parent;
        @XmlValue
        private String value;

        private Thread() {
        }
    }

    public static final class Subject {
        @XmlAttribute(name="lang", namespace="http://www.w3.org/XML/1998/namespace")
        private String language;
        @XmlValue
        private String text;

        private Subject() {
        }

        public Subject(String text) {
            this.text = text;
        }

        public Subject(String text, String language) {
            this.text = text;
            this.language = language;
        }

        public String getLanguage() {
            return this.language;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }

    public static final class Body {
        @XmlAttribute(name="lang", namespace="http://www.w3.org/XML/1998/namespace")
        private String language;
        @XmlValue
        private String text;

        private Body() {
        }

        public Body(String text) {
            this.text = text;
        }

        public Body(String text, String language) {
            this.text = text;
            this.language = language;
        }

        public String getLanguage() {
            return this.language;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }

    @XmlType(name="messageType")
    public static enum Type {
        NORMAL,
        CHAT,
        HEADLINE,
        GROUPCHAT,
        ERROR;

    }
}

