/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.data.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import rocks.xmpp.extensions.data.layout.model.Page;
import rocks.xmpp.extensions.data.mediaelement.model.Media;
import rocks.xmpp.extensions.data.validate.model.Validation;

@XmlRootElement(name="x")
public final class DataForm
implements Comparable<DataForm> {
    private static final String FORM_TYPE = "FORM_TYPE";
    @XmlElement
    private final List<String> instructions = new ArrayList<String>();
    @XmlElementRef
    private final List<Page> pages = new ArrayList<Page>();
    @XmlElement(name="field")
    private final List<Field> fields = new ArrayList<Field>();
    @XmlElement(name="item")
    private final List<Item> items = new ArrayList<Item>();
    @XmlAttribute
    private Type type;
    @XmlElement
    private String title;
    @XmlElementWrapper(name="reported")
    @XmlElement(name="field")
    private List<Field> reportedFields;

    private DataForm() {
    }

    public DataForm(Type type) {
        this.type = type;
    }

    public DataForm(Type type, String title) {
        this.type = type;
        this.title = title;
    }

    public DataForm(Type type, String title, String ... instructions) {
        this.type = type;
        this.title = title;
        this.instructions.addAll(Arrays.asList(instructions));
    }

    public static boolean parseBoolean(String value) {
        return Boolean.parseBoolean(value) || "1".equals(value);
    }

    public String getFormType() {
        for (Field field : this.getFields()) {
            if (!FORM_TYPE.equals(field.getVar()) || field.getValues().isEmpty()) continue;
            return field.getValues().get(0);
        }
        return null;
    }

    public void setFormType(String formType) {
        Field field = this.findField(FORM_TYPE);
        if (field == null) {
            field = new Field(Field.Type.HIDDEN, FORM_TYPE, new String[0]);
            this.getFields().add(0, field);
        }
        field.getValues().clear();
        field.getValues().add(formType);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public List<String> getInstructions() {
        return this.instructions;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public List<Field> getReportedFields() {
        return this.reportedFields;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public Field findField(String name) {
        if (name != null) {
            for (Field field : this.fields) {
                if (!name.equals(field.getVar())) continue;
                return field;
            }
        }
        return null;
    }

    @Override
    public int compareTo(DataForm o) {
        String fto;
        String ft = this.getFormType();
        String string = fto = o != null ? o.getFormType() : null;
        if (ft == null && fto == null) {
            return 0;
        }
        if (ft == null) {
            return 1;
        }
        if (fto == null) {
            return -1;
        }
        return ft.compareTo(fto);
    }

    public List<Page> getPages() {
        return this.pages;
    }

    public static final class Option {
        @XmlAttribute(name="label")
        private String label;
        @XmlElement(name="value")
        private String value;

        private Option() {
        }

        public Option(String value) {
            this.value = value;
        }

        public Option(String value, String label) {
            this.value = value;
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static final class Item {
        @XmlElement(name="field")
        private final List<Field> fields = new ArrayList<Field>();

        public List<Field> getFields() {
            return this.fields;
        }
    }

    @XmlRootElement(name="field")
    public static final class Field
    implements Comparable<Field> {
        @XmlElement(name="option")
        private final List<Option> options = new ArrayList<Option>();
        @XmlElement(name="desc")
        private String description;
        @XmlElement(name="required")
        private String required;
        @XmlElementRef
        private Validation validation;
        @XmlElement(name="value")
        private List<String> values = new ArrayList<String>();
        @XmlElementRef
        private Media media;
        @XmlAttribute(name="label")
        private String label;
        @XmlAttribute(name="type")
        private Type type;
        @XmlAttribute(name="var")
        private String var;

        private Field() {
        }

        public Field(Type type) {
            this.type = type;
        }

        public Field(Type type, String var, String ... values) {
            this.type = type;
            this.var = var;
            this.values = new ArrayList<String>(Arrays.asList(values));
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public String getVar() {
            return this.var;
        }

        public void setVar(String var) {
            this.var = var;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public List<Option> getOptions() {
            return this.options;
        }

        public List<String> getValues() {
            return this.values;
        }

        public Media getMedia() {
            return this.media;
        }

        public void setMedia(Media media) {
            this.media = media;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Validation getValidation() {
            return this.validation;
        }

        public void setValidation(Validation validation) {
            this.validation = validation;
        }

        public boolean isRequired() {
            return this.required != null;
        }

        public void setRequired(boolean required) {
            this.required = required ? "" : null;
        }

        @Override
        public int compareTo(Field o) {
            if (DataForm.FORM_TYPE.equals(this.getVar()) && !DataForm.FORM_TYPE.equals(o.getVar())) {
                return -1;
            }
            if (this.getVar() == null && o.getVar() == null) {
                return 0;
            }
            if (this.getVar() == null) {
                return -1;
            }
            if (o.getVar() == null) {
                return 1;
            }
            return this.getVar().compareTo(o.getVar());
        }

        @XmlEnum
        @XmlType(name="field-type")
        public static enum Type {
            BOOLEAN,
            FIXED,
            HIDDEN,
            JID_MULTI,
            JID_SINGLE,
            LIST_MULTI,
            LIST_SINGLE,
            TEXT_MULTI,
            TEXT_PRIVATE,
            TEXT_SINGLE;

        }
    }

    @XmlEnum
    @XmlType(name="form-type")
    public static enum Type {
        CANCEL,
        FORM,
        RESULT,
        SUBMIT;

    }
}

