/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stanza;

import java.util.ArrayList;
import java.util.Collections;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.XmlTest;
import rocks.xmpp.core.stanza.model.AbstractPresence;
import rocks.xmpp.core.stanza.model.client.Presence;
import rocks.xmpp.core.stanza.model.errors.RemoteServerNotFound;

public class PresenceTest
extends XmlTest {
    protected PresenceTest() throws JAXBException, XMLStreamException {
        super(Presence.class, RemoteServerNotFound.class);
    }

    @Test
    public void unmarshalPresence() throws XMLStreamException, JAXBException {
        String xml = "<presence from='romeo@example.net'              id='xk3h1v69'\n              to='juliet@example.com'\n              type='subscribe'/>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((String)presence.getTo().toString(), (String)"juliet@example.com");
        Assert.assertEquals((String)presence.getFrom().toString(), (String)"romeo@example.net");
        Assert.assertEquals((Object)presence.getType(), (Object)AbstractPresence.Type.SUBSCRIBE);
        Assert.assertEquals((String)presence.getId(), (String)"xk3h1v69");
    }

    @Test
    public void unmarshalPresenceWithError() throws XMLStreamException, JAXBException {
        String xml = "<presence from='juliet@example.com'\n              id='xk3h1v69'\n              to='romeo@example.net'\n              type='error'>\n      <error type='modify'>\n        <remote-server-not-found\n            xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/>\n      </error>\n    </presence>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((String)presence.getTo().toString(), (String)"romeo@example.net");
        Assert.assertEquals((String)presence.getFrom().toString(), (String)"juliet@example.com");
        Assert.assertEquals((Object)presence.getType(), (Object)AbstractPresence.Type.ERROR);
        Assert.assertNotNull((Object)presence.getError());
        Assert.assertNotNull((Object)(presence.getError().getCondition() instanceof RemoteServerNotFound));
    }

    @Test
    public void unmarshalPresenceTypeSubscribed() throws XMLStreamException, JAXBException {
        String xml = "<presence from='juliet@example.com'\n              id='xk3h1v69'\n              to='romeo@example.net'\n              type='subscribed'/>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((String)presence.getFrom().toString(), (String)"juliet@example.com");
        Assert.assertEquals((String)presence.getTo().toString(), (String)"romeo@example.net");
        Assert.assertEquals((Object)presence.getType(), (Object)AbstractPresence.Type.SUBSCRIBED);
        Assert.assertEquals((String)presence.getId(), (String)"xk3h1v69");
    }

    @Test
    public void unmarshalPresenceTypeUnsubscribed() throws XMLStreamException, JAXBException {
        String xml = "<presence id='tb2m1b59'\n              to='romeo@example.net'\n              type='unsubscribed'/>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((String)presence.getTo().toString(), (String)"romeo@example.net");
        Assert.assertEquals((Object)presence.getType(), (Object)AbstractPresence.Type.UNSUBSCRIBED);
        Assert.assertEquals((String)presence.getId(), (String)"tb2m1b59");
    }

    @Test
    public void unmarshalPresenceTypeUnsubscribe() throws XMLStreamException, JAXBException {
        String xml = "<presence id='tb2m1b59'\n              to='romeo@example.net'\n              type='unsubscribe'/>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((String)presence.getTo().toString(), (String)"romeo@example.net");
        Assert.assertEquals((Object)presence.getType(), (Object)AbstractPresence.Type.UNSUBSCRIBE);
        Assert.assertEquals((String)presence.getId(), (String)"tb2m1b59");
    }

    @Test
    public void unmarshalPresenceTypeProbe() throws XMLStreamException, JAXBException {
        String xml = "<presence id='tb2m1b59'\n              to='romeo@example.net'\n              type='probe'/>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((String)presence.getTo().toString(), (String)"romeo@example.net");
        Assert.assertEquals((Object)presence.getType(), (Object)AbstractPresence.Type.PROBE);
        Assert.assertEquals((String)presence.getId(), (String)"tb2m1b59");
    }

    @Test
    public void unmarshalPresenceTypeUnavailable() throws XMLStreamException, JAXBException {
        String xml = "<presence id='tb2m1b59'\n              to='romeo@example.net'\n              type='unavailable'/>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((String)presence.getTo().toString(), (String)"romeo@example.net");
        Assert.assertEquals((Object)presence.getType(), (Object)AbstractPresence.Type.UNAVAILABLE);
        Assert.assertEquals((String)presence.getId(), (String)"tb2m1b59");
    }

    @Test
    public void unmarshalPresenceStatus() throws XMLStreamException, JAXBException {
        String xml = "<presence from='romeo@example.net/orchard'\n          xml:lang='en'>\n  <show>dnd</show>\n  <status>Wooing Juliet</status>\n</presence>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((String)presence.getFrom().toString(), (String)"romeo@example.net/orchard");
        Assert.assertEquals((Object)presence.getShow(), (Object)AbstractPresence.Show.DND);
        Assert.assertEquals((String)presence.getLanguage(), (String)"en");
        Assert.assertEquals((String)presence.getStatus(), (String)"Wooing Juliet");
    }

    @Test
    public void unmarshalMultiplePresenceStatus() throws XMLStreamException, JAXBException {
        String xml = "<presence from='romeo@example.net/orchard'\n          id='jx62vs97'\n          xml:lang='en'>\n  <show>dnd</show>\n  <status>Wooing Juliet</status>\n  <status xml:lang='de'>Julia</status>\n</presence>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((String)presence.getFrom().toString(), (String)"romeo@example.net/orchard");
        Assert.assertEquals((Object)presence.getShow(), (Object)AbstractPresence.Show.DND);
        Assert.assertEquals((String)presence.getLanguage(), (String)"en");
        Assert.assertEquals((String)presence.getStatus(), (String)"Wooing Juliet");
    }

    @Test
    public void unmarshalPresenceShowAway() throws XMLStreamException, JAXBException {
        String xml = "<presence from='romeo@example.net/orchard'\n          xml:lang='en'>\n  <show>away</show>\n</presence>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((Object)presence.getShow(), (Object)AbstractPresence.Show.AWAY);
    }

    @Test
    public void unmarshalPresenceShowXA() throws XMLStreamException, JAXBException {
        String xml = "<presence from='romeo@example.net/orchard'\n          xml:lang='en'>\n  <show>xa</show>\n</presence>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((Object)presence.getShow(), (Object)AbstractPresence.Show.XA);
    }

    @Test
    public void unmarshalPresenceShowChat() throws XMLStreamException, JAXBException {
        String xml = "<presence from='romeo@example.net/orchard'\n          xml:lang='en'>\n  <show>chat</show>\n</presence>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((Object)presence.getShow(), (Object)AbstractPresence.Show.CHAT);
    }

    @Test
    public void unmarshalPresenceShowDnd() throws XMLStreamException, JAXBException {
        String xml = "<presence from='romeo@example.net/orchard'\n          xml:lang='en'>\n  <show>dnd</show>\n</presence>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((Object)presence.getShow(), (Object)AbstractPresence.Show.DND);
    }

    @Test
    public void unmarshalPriority() throws XMLStreamException, JAXBException {
        String xml = "<presence xml:lang='en'>\n  <show>dnd</show>\n  <status>Wooing Juliet</status>\n  <status xml:lang='cs'>Dvo&#x0159;&#x00ED;m se Julii</status>\n  <priority>1</priority>\n</presence>";
        Presence presence = this.unmarshal(xml, Presence.class);
        Assert.assertEquals((int)presence.getPriority(), (int)1);
    }

    @Test
    public void marshalPresenceMultipleStatus() throws JAXBException, XMLStreamException {
        Presence presence = new Presence(AbstractPresence.Type.SUBSCRIBE);
        presence.setId("id");
        presence.setTo(new Jid("to", "domain"));
        presence.setFrom(new Jid("from", "domain"));
        presence.getStatuses().add(new AbstractPresence.Status("status", "de"));
        AbstractPresence.Status status = new AbstractPresence.Status("status2");
        status.setLanguage("en");
        presence.getStatuses().add(status);
        String xml = this.marshal(presence);
        Assert.assertEquals((String)xml, (String)"<presence from=\"from@domain\" id=\"id\" to=\"to@domain\" type=\"subscribe\"><status xml:lang=\"de\">status</status><status xml:lang=\"en\">status2</status></presence>");
    }

    @Test
    public void marshalPresenceShowDnd() throws JAXBException, XMLStreamException {
        Presence presence = new Presence(AbstractPresence.Type.SUBSCRIBED);
        presence.setId("id");
        presence.setTo(new Jid("to", "domain"));
        presence.setFrom(new Jid("from", "domain"));
        presence.setShow(AbstractPresence.Show.DND);
        String xml = this.marshal(presence);
        Assert.assertEquals((String)xml, (String)"<presence from=\"from@domain\" id=\"id\" to=\"to@domain\" type=\"subscribed\"><show>dnd</show></presence>");
    }

    @Test
    public void marshalPresenceShowAway() throws JAXBException, XMLStreamException {
        Presence presence = new Presence(AbstractPresence.Type.UNSUBSCRIBE);
        presence.setId("id");
        presence.setTo(new Jid("to", "domain"));
        presence.setFrom(new Jid("from", "domain"));
        presence.setShow(AbstractPresence.Show.AWAY);
        String xml = this.marshal(presence);
        Assert.assertEquals((String)xml, (String)"<presence from=\"from@domain\" id=\"id\" to=\"to@domain\" type=\"unsubscribe\"><show>away</show></presence>");
    }

    @Test
    public void marshalPresenceShowXA() throws JAXBException, XMLStreamException {
        Presence presence = new Presence(AbstractPresence.Type.UNSUBSCRIBED);
        presence.setId("id");
        presence.setTo(new Jid("to", "domain"));
        presence.setFrom(new Jid("from", "domain"));
        presence.setShow(AbstractPresence.Show.XA);
        String xml = this.marshal(presence);
        Assert.assertEquals((String)xml, (String)"<presence from=\"from@domain\" id=\"id\" to=\"to@domain\" type=\"unsubscribed\"><show>xa</show></presence>");
    }

    @Test
    public void marshalPresenceShowChat() throws JAXBException, XMLStreamException {
        Presence presence = new Presence(AbstractPresence.Type.UNAVAILABLE);
        presence.setId("id");
        presence.setTo(new Jid("to", "domain"));
        presence.setFrom(new Jid("from", "domain"));
        presence.setShow(AbstractPresence.Show.CHAT);
        String xml = this.marshal(presence);
        Assert.assertEquals((String)xml, (String)"<presence from=\"from@domain\" id=\"id\" to=\"to@domain\" type=\"unavailable\"><show>chat</show></presence>");
    }

    @Test
    public void testIsAvailable() throws JAXBException, XMLStreamException {
        Presence presence1 = new Presence();
        Assert.assertTrue((boolean)presence1.isAvailable());
        Presence presence2 = new Presence(AbstractPresence.Type.SUBSCRIBE);
        Assert.assertFalse((boolean)presence2.isAvailable());
        Presence presence3 = new Presence(AbstractPresence.Type.UNSUBSCRIBED);
        Assert.assertFalse((boolean)presence3.isAvailable());
        Presence presence4 = new Presence(AbstractPresence.Type.UNSUBSCRIBE);
        Assert.assertFalse((boolean)presence4.isAvailable());
        Presence presence5 = new Presence(AbstractPresence.Type.SUBSCRIBED);
        Assert.assertFalse((boolean)presence5.isAvailable());
        Presence presence6 = new Presence(AbstractPresence.Type.ERROR);
        Assert.assertFalse((boolean)presence6.isAvailable());
        Presence presence7 = new Presence(AbstractPresence.Type.PROBE);
        Assert.assertFalse((boolean)presence7.isAvailable());
        Presence presence8 = new Presence(AbstractPresence.Type.UNAVAILABLE);
        Assert.assertFalse((boolean)presence8.isAvailable());
    }

    @Test
    public void testComparableImplementation() {
        Presence presenceUnavailable = new Presence(AbstractPresence.Type.UNAVAILABLE);
        Presence presenceDnd = new Presence(AbstractPresence.Show.DND);
        presenceDnd.setPriority((byte)1);
        Presence presenceAway = new Presence(AbstractPresence.Show.AWAY);
        presenceAway.setPriority((byte)1);
        Presence presenceXa = new Presence(AbstractPresence.Show.XA);
        presenceXa.setPriority((byte)1);
        Presence presenceChat = new Presence(AbstractPresence.Show.CHAT);
        presenceChat.setPriority((byte)1);
        Presence presencePrio1 = new Presence();
        presencePrio1.setPriority((byte)1);
        Presence presencePrio2 = new Presence();
        presencePrio2.setPriority((byte)2);
        Presence presencePrio1Unavailble = new Presence(AbstractPresence.Type.UNAVAILABLE);
        presencePrio1Unavailble.setPriority((byte)1);
        ArrayList<Presence> list = new ArrayList<Presence>();
        list.add(presenceAway);
        list.add(presenceDnd);
        list.add(presenceChat);
        list.add(presenceXa);
        list.add(presenceUnavailable);
        list.add(presencePrio1);
        list.add(presencePrio2);
        list.add(presencePrio1Unavailble);
        Collections.shuffle(list);
        Collections.sort(list);
        Assert.assertEquals(list.get(0), (Object)presencePrio1);
        Assert.assertEquals(list.get(1), (Object)presenceChat);
        Assert.assertEquals(list.get(2), (Object)presenceAway);
        Assert.assertEquals(list.get(3), (Object)presenceXa);
        Assert.assertEquals(list.get(4), (Object)presenceDnd);
        Assert.assertEquals(list.get(5), (Object)presencePrio2);
        Assert.assertEquals(list.get(6), (Object)presenceUnavailable);
        Assert.assertEquals(list.get(7), (Object)presencePrio1Unavailble);
    }
}

