/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stream;

import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.core.XmlTest;
import rocks.xmpp.core.stream.model.StreamError;
import rocks.xmpp.core.stream.model.errors.BadFormat;
import rocks.xmpp.core.stream.model.errors.BadNamespacePrefix;
import rocks.xmpp.core.stream.model.errors.Conflict;
import rocks.xmpp.core.stream.model.errors.ConnectionTimeout;
import rocks.xmpp.core.stream.model.errors.HostGone;
import rocks.xmpp.core.stream.model.errors.HostUnknown;
import rocks.xmpp.core.stream.model.errors.ImproperAddressing;
import rocks.xmpp.core.stream.model.errors.InternalServerError;
import rocks.xmpp.core.stream.model.errors.InvalidFrom;
import rocks.xmpp.core.stream.model.errors.InvalidNamespace;
import rocks.xmpp.core.stream.model.errors.InvalidXml;
import rocks.xmpp.core.stream.model.errors.NotAuthorized;
import rocks.xmpp.core.stream.model.errors.NotWellFormed;
import rocks.xmpp.core.stream.model.errors.PolicyViolation;
import rocks.xmpp.core.stream.model.errors.RemoteConnectionFailed;
import rocks.xmpp.core.stream.model.errors.Reset;
import rocks.xmpp.core.stream.model.errors.ResourceConstraint;
import rocks.xmpp.core.stream.model.errors.RestrictedXml;
import rocks.xmpp.core.stream.model.errors.SeeOtherHost;
import rocks.xmpp.core.stream.model.errors.SystemShutdown;
import rocks.xmpp.core.stream.model.errors.UndefinedCondition;
import rocks.xmpp.core.stream.model.errors.UnsupportedEncoding;
import rocks.xmpp.core.stream.model.errors.UnsupportedFeature;
import rocks.xmpp.core.stream.model.errors.UnsupportedStanzaType;
import rocks.xmpp.core.stream.model.errors.UnsupportedVersion;

public class StreamErrorTest
extends XmlTest {
    protected StreamErrorTest() throws JAXBException, XMLStreamException {
        super(StreamError.class);
    }

    @Test
    public void unmarshalBadFormat() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <bad-format\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((boolean)(streamError.getCondition() instanceof BadFormat));
    }

    @Test
    public void unmarshalBadNamespacePrefix() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <bad-namespace-prefix\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((boolean)(streamError.getCondition() instanceof BadNamespacePrefix));
    }

    @Test
    public void unmarshalConflict() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <conflict\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((boolean)(streamError.getCondition() instanceof Conflict));
    }

    @Test
    public void unmarshalConnectionTimeout() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <connection-timeout\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((boolean)(streamError.getCondition() instanceof ConnectionTimeout));
    }

    @Test
    public void unmarshalHostGone() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <host-gone\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((boolean)(streamError.getCondition() instanceof HostGone));
    }

    @Test
    public void unmarshalHostUnknown() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <host-unknown\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((boolean)(streamError.getCondition() instanceof HostUnknown));
    }

    @Test
    public void unmarshalImproperAddressing() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <improper-addressing\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((boolean)(streamError.getCondition() instanceof ImproperAddressing));
    }

    @Test
    public void unmarshalInternalServerError() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <internal-server-error\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((boolean)(streamError.getCondition() instanceof InternalServerError));
    }

    @Test
    public void unmarshalInvalidFrom() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <invalid-from\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((boolean)(streamError.getCondition() instanceof InvalidFrom));
    }

    @Test
    public void unmarshalInvalidNamespace() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <invalid-namespace\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((boolean)(streamError.getCondition() instanceof InvalidNamespace));
    }

    @Test
    public void unmarshalInvalidXml() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <invalid-xml\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((boolean)(streamError.getCondition() instanceof InvalidXml));
    }

    @Test
    public void unmarshalNotAuthorized() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <not-authorized\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((boolean)(streamError.getCondition() instanceof NotAuthorized));
    }

    @Test
    public void unmarshalNotWellFormed() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <not-well-formed\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((boolean)(streamError.getCondition() instanceof NotWellFormed));
    }

    @Test
    public void unmarshalPolicyViolation() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <policy-violation\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((boolean)(streamError.getCondition() instanceof PolicyViolation));
    }

    @Test
    public void unmarshalRemoteConnectionFailed() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <remote-connection-failed\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((boolean)(streamError.getCondition() instanceof RemoteConnectionFailed));
    }

    @Test
    public void unmarshalReset() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <reset\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((boolean)(streamError.getCondition() instanceof Reset));
    }

    @Test
    public void unmarshalResourceConstraint() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <resource-constraint\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((boolean)(streamError.getCondition() instanceof ResourceConstraint));
    }

    @Test
    public void unmarshalRestrictedXml() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <restricted-xml\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((boolean)(streamError.getCondition() instanceof RestrictedXml));
    }

    @Test
    public void unmarshalSeeOtherHost() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <see-other-host\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'>[2001:41D0:1:A49b::1]:9222</see-other-host>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((boolean)(streamError.getCondition() instanceof SeeOtherHost));
        Assert.assertEquals((String)((SeeOtherHost)streamError.getCondition()).getOtherHost(), (String)"[2001:41D0:1:A49b::1]:9222");
    }

    @Test
    public void unmarshalSystemShutdown() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <system-shutdown\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((boolean)(streamError.getCondition() instanceof SystemShutdown));
    }

    @Test
    public void unmarshalUndefinedCondition() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <undefined-condition\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((boolean)(streamError.getCondition() instanceof UndefinedCondition));
    }

    @Test
    public void unmarshalUnsupportedEncoding() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <unsupported-encoding\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((boolean)(streamError.getCondition() instanceof UnsupportedEncoding));
    }

    @Test
    public void unmarshalUnsupportedFeature() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <unsupported-feature\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((boolean)(streamError.getCondition() instanceof UnsupportedFeature));
    }

    @Test
    public void unmarshalUnsupportedStanzaType() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <unsupported-stanza-type\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((boolean)(streamError.getCondition() instanceof UnsupportedStanzaType));
    }

    @Test
    public void shouldUnmarshalUnsupportedVersion() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <unsupported-version\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertTrue((boolean)(streamError.getCondition() instanceof UnsupportedVersion));
    }

    @Test
    public void shouldUnmarshalErrorWithText() throws JAXBException, XMLStreamException {
        String xml = "<stream:error>\n     <host-unknown\n         xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>\n     <text xmlns='urn:ietf:params:xml:ns:xmpp-streams'\n           xml:lang='en'>OPTIONAL descriptive text</text>   </stream:error>";
        StreamError streamError = this.unmarshal(xml, StreamError.class);
        Assert.assertEquals((String)streamError.getText(), (String)"OPTIONAL descriptive text");
        Assert.assertEquals((String)streamError.getLanguage(), (String)"en");
        Assert.assertTrue((boolean)(streamError.getCondition() instanceof HostUnknown));
    }
}

