/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.compress;

import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.core.XmlTest;
import rocks.xmpp.extensions.compress.model.Compress;
import rocks.xmpp.extensions.compress.model.CompressionMethod;
import rocks.xmpp.extensions.compress.model.Failure;
import rocks.xmpp.extensions.compress.model.feature.Compression;

public class CompressionTest
extends XmlTest {
    protected CompressionTest() throws JAXBException, XMLStreamException {
        super(Compress.class);
    }

    @Test
    public void unmarshalCompression() throws XMLStreamException, JAXBException {
        String xml = "<compression xmlns='http://jabber.org/features/compress'>\n    <method>zlib</method>\n    <method>lzw</method>\n  </compression>\n";
        Compression compression = this.unmarshal(xml, Compression.class);
        Assert.assertNotNull((Object)compression);
        Assert.assertEquals((int)compression.getMethods().size(), (int)2);
        Assert.assertEquals(compression.getMethods().get(0), (Object)CompressionMethod.ZLIB);
    }

    @Test
    public void marshalCompress() throws JAXBException, XMLStreamException {
        Compress compress = new Compress(CompressionMethod.ZLIB);
        String xml = this.marshal(compress);
        Assert.assertEquals((String)xml, (String)"<compress xmlns=\"http://jabber.org/protocol/compress\"><method>zlib</method></compress>");
    }

    @Test
    public void unmarshalFailureUnsupportedMethod() throws XMLStreamException, JAXBException {
        String xml = "<failure xmlns='http://jabber.org/protocol/compress'>\n  <unsupported-method/>\n</failure>\n";
        Failure failure = this.unmarshal(xml, Failure.class);
        Assert.assertNotNull((Object)failure);
        Assert.assertTrue((boolean)(failure.getCondition() instanceof Failure.UnsupportedMethod));
    }

    @Test
    public void unmarshalFailureSetupFailed() throws XMLStreamException, JAXBException {
        String xml = "<failure xmlns='http://jabber.org/protocol/compress'>\n  <setup-failed/>\n</failure>\n";
        Failure failure = this.unmarshal(xml, Failure.class);
        Assert.assertNotNull((Object)failure);
        Assert.assertTrue((boolean)(failure.getCondition() instanceof Failure.SetupFailed));
    }

    @Test
    public void unmarshalFailureProcessingFailed() throws XMLStreamException, JAXBException {
        String xml = "<failure xmlns='http://jabber.org/protocol/compress'>\n  <processing-failed/>\n</failure>\n";
        Failure failure = this.unmarshal(xml, Failure.class);
        Assert.assertNotNull((Object)failure);
        Assert.assertTrue((boolean)(failure.getCondition() instanceof Failure.ProcessingFailed));
    }
}

