/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.data.mediaelement;

import java.net.URI;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.core.XmlTest;
import rocks.xmpp.extensions.data.mediaelement.model.Media;
import rocks.xmpp.extensions.data.model.DataForm;

public class DataFormsMediaTest
extends XmlTest {
    protected DataFormsMediaTest() throws JAXBException, XMLStreamException {
        super(DataForm.class, Media.class);
    }

    @Test
    public void unmarshalDataFormWithMedia1() throws XMLStreamException, JAXBException {
        String xml = "<x xmlns='jabber:x:data' type='form'>\n  <field var='ocr'>\n    <media xmlns='urn:xmpp:media-element'>\n  <uri type='audio/x-wav'>\n    http://victim.example.com/challenges/speech.wav?F3A6292C\n  </uri>\n  <uri type='audio/ogg; codecs=speex'>\n    cid:sha1+a15a505e360702b79c75a5f67773072ed392f52a@bob.xmpp.org\n  </uri>\n  <uri type='audio/mpeg'>\n    http://victim.example.com/challenges/speech.mp3?F3A6292C\n  </uri>\n   </media>  </field>\n</x>\n";
        DataForm dataForm = this.unmarshal(xml, DataForm.class);
        Assert.assertNotNull((Object)dataForm);
        Assert.assertEquals((Object)dataForm.getType(), (Object)DataForm.Type.FORM);
        Media media = ((DataForm.Field)dataForm.getFields().get(0)).getMedia();
        Assert.assertNotNull((Object)media);
        Assert.assertEquals((int)media.getHeight(), (int)0);
        Assert.assertEquals((int)media.getWidth(), (int)0);
    }

    @Test
    public void unmarshalDataFormWithMedia2() throws XMLStreamException, JAXBException {
        String xml = "<x xmlns='jabber:x:data' type='form'>\n  <field var='ocr'>\n    <media xmlns='urn:xmpp:media-element'\n           height='80'\n           width='290'>\n      <uri type='image/jpeg'>http://www.victim.com/challenges/ocr.jpeg?F3A6292C</uri>\n      <uri type='image/jpeg'>cid:sha1+f24030b8d91d233bac14777be5ab531ca3b9f102@bob.xmpp.org</uri>\n    </media>\n  </field>\n</x>\n";
        DataForm dataForm = this.unmarshal(xml, DataForm.class);
        Assert.assertNotNull((Object)dataForm);
        Assert.assertEquals((Object)dataForm.getType(), (Object)DataForm.Type.FORM);
        Media media = ((DataForm.Field)dataForm.getFields().get(0)).getMedia();
        Assert.assertNotNull((Object)media);
        Assert.assertEquals((int)media.getHeight(), (int)80);
        Assert.assertEquals((int)media.getWidth(), (int)290);
        Assert.assertEquals((int)media.getLocations().size(), (int)2);
        Assert.assertEquals((String)((Media.Location)media.getLocations().get(0)).getType(), (String)"image/jpeg");
        Assert.assertEquals((Object)((Media.Location)media.getLocations().get(0)).getUri(), (Object)URI.create("http://www.victim.com/challenges/ocr.jpeg?F3A6292C"));
        Assert.assertEquals((String)((Media.Location)media.getLocations().get(1)).getType(), (String)"image/jpeg");
        Assert.assertEquals((Object)((Media.Location)media.getLocations().get(1)).getUri(), (Object)URI.create("cid:sha1+f24030b8d91d233bac14777be5ab531ca3b9f102@bob.xmpp.org"));
    }
}

