/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.sasl.model;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlValue;
import rocks.xmpp.core.stream.model.ServerStreamElement;

@XmlRootElement
@XmlSeeAlso(value={Aborted.class, AccountDisabled.class, CredentialsExpired.class, EncryptionRequired.class, IncorrectEncoding.class, InvalidAuthzid.class, InvalidMechanism.class, MalformedRequest.class, MechanismTooWeak.class, NotAuthorized.class, TemporaryAuthFailure.class})
public final class Failure
implements ServerStreamElement {
    @XmlElementRef
    private Condition condition;
    @XmlElement(name="text")
    private Text text;

    private Failure() {
    }

    public Condition getCondition() {
        return this.condition;
    }

    public String getText() {
        if (this.text != null) {
            return this.text.text;
        }
        return null;
    }

    public String getLanguage() {
        if (this.text != null) {
            return this.text.language;
        }
        return null;
    }

    private static class Text {
        @XmlValue
        private String text;
        @XmlAttribute(name="lang", namespace="http://www.w3.org/XML/1998/namespace")
        private String language;

        private Text() {
        }
    }

    public static abstract class Condition {
    }

    @XmlRootElement(name="temporary-auth-failure")
    public static final class TemporaryAuthFailure
    extends Condition {
        private TemporaryAuthFailure() {
        }
    }

    @XmlRootElement(name="not-authorized")
    public static final class NotAuthorized
    extends Condition {
        private NotAuthorized() {
        }
    }

    @XmlRootElement(name="mechanism-too-weak")
    public static final class MechanismTooWeak
    extends Condition {
        private MechanismTooWeak() {
        }
    }

    @XmlRootElement(name="malformed-request")
    public static class MalformedRequest
    extends Condition {
        private MalformedRequest() {
        }
    }

    @XmlRootElement(name="invalid-mechanism")
    public static final class InvalidMechanism
    extends Condition {
        private InvalidMechanism() {
        }
    }

    @XmlRootElement(name="invalid-authzid")
    public static final class InvalidAuthzid
    extends Condition {
        private InvalidAuthzid() {
        }
    }

    @XmlRootElement(name="incorrect-encoding")
    public static final class IncorrectEncoding
    extends Condition {
        private IncorrectEncoding() {
        }
    }

    @XmlRootElement(name="encryption-required")
    public static final class EncryptionRequired
    extends Condition {
        private EncryptionRequired() {
        }
    }

    @XmlRootElement(name="credentials-expired")
    public static final class CredentialsExpired
    extends Condition {
        private CredentialsExpired() {
        }
    }

    @XmlRootElement(name="account-disabled")
    public static final class AccountDisabled
    extends Condition {
        private AccountDisabled() {
        }
    }

    @XmlRootElement(name="aborted")
    public static final class Aborted
    extends Condition {
        private Aborted() {
        }
    }
}

