/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stanza.model;

import java.util.UUID;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.stanza.model.Stanza;

@XmlTransient
public abstract class AbstractIQ
extends Stanza {
    @XmlAttribute
    private Type type;
    @XmlAnyElement(lax=true)
    private Object extension;

    protected AbstractIQ() {
    }

    protected AbstractIQ(Type type) {
        this(UUID.randomUUID().toString(), type, null);
    }

    protected AbstractIQ(Type type, Object extension) {
        this(UUID.randomUUID().toString(), type, extension);
    }

    protected AbstractIQ(String id, Type type, Object extension) {
        this(null, id, type, extension);
    }

    protected AbstractIQ(Jid to, Type type, Object extension) {
        this(to, UUID.randomUUID().toString(), type, extension);
    }

    protected AbstractIQ(Jid to, String id, Type type, Object extension) {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("type must not be null.");
        }
        this.to = to;
        this.id = id;
        this.type = type;
        this.extension = extension;
    }

    public final Type getType() {
        return this.type;
    }

    @Override
    public final <T> T getExtension(Class<T> type) {
        if (this.extension != null && type != null && type.isAssignableFrom(this.extension.getClass())) {
            return (T)this.extension;
        }
        return null;
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder("IQ");
        if (this.type != null) {
            sb.append("-").append(this.type.name().toLowerCase());
        }
        return sb.append(super.toString()).toString();
    }

    public final void setExtension(Object extension) {
        this.extension = extension;
    }

    public final boolean isRequest() {
        return this.type == Type.GET || this.type == Type.SET;
    }

    public final boolean isResponse() {
        return this.type == Type.RESULT || this.type == Type.ERROR;
    }

    @XmlType(name="iqType")
    public static enum Type {
        ERROR,
        GET,
        RESULT,
        SET;

    }
}

