/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.stanza.model;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlSeeAlso;
import rocks.xmpp.core.Jid;
import rocks.xmpp.core.stanza.model.errors.BadRequest;
import rocks.xmpp.core.stanza.model.errors.Condition;
import rocks.xmpp.core.stanza.model.errors.Conflict;
import rocks.xmpp.core.stanza.model.errors.FeatureNotImplemented;
import rocks.xmpp.core.stanza.model.errors.Forbidden;
import rocks.xmpp.core.stanza.model.errors.Gone;
import rocks.xmpp.core.stanza.model.errors.InternalServerError;
import rocks.xmpp.core.stanza.model.errors.ItemNotFound;
import rocks.xmpp.core.stanza.model.errors.JidMalformed;
import rocks.xmpp.core.stanza.model.errors.NotAcceptable;
import rocks.xmpp.core.stanza.model.errors.NotAllowed;
import rocks.xmpp.core.stanza.model.errors.NotAuthorized;
import rocks.xmpp.core.stanza.model.errors.PolicyViolation;
import rocks.xmpp.core.stanza.model.errors.RecipientUnavailable;
import rocks.xmpp.core.stanza.model.errors.Redirect;
import rocks.xmpp.core.stanza.model.errors.RegistrationRequired;
import rocks.xmpp.core.stanza.model.errors.RemoteServerNotFound;
import rocks.xmpp.core.stanza.model.errors.RemoteServerTimeout;
import rocks.xmpp.core.stanza.model.errors.ResourceConstraint;
import rocks.xmpp.core.stanza.model.errors.ServiceUnavailable;
import rocks.xmpp.core.stanza.model.errors.SubscriptionRequired;
import rocks.xmpp.core.stanza.model.errors.Text;
import rocks.xmpp.core.stanza.model.errors.UndefinedCondition;
import rocks.xmpp.core.stanza.model.errors.UnexpectedRequest;

@XmlSeeAlso(value={Text.class, BadRequest.class, Conflict.class, FeatureNotImplemented.class, Conflict.class, Forbidden.class, Gone.class, InternalServerError.class, ItemNotFound.class, JidMalformed.class, NotAcceptable.class, NotAllowed.class, NotAuthorized.class, PolicyViolation.class, RecipientUnavailable.class, Redirect.class, RegistrationRequired.class, RemoteServerNotFound.class, RemoteServerTimeout.class, ResourceConstraint.class, ServiceUnavailable.class, SubscriptionRequired.class, UndefinedCondition.class, UnexpectedRequest.class})
public final class StanzaError {
    private static final Map<Class<? extends Condition>, Type> ASSOCIATED_ERROR_TYPE = new HashMap<Class<? extends Condition>, Type>();
    @XmlAttribute(name="by")
    private Jid by;
    @XmlAttribute(name="type")
    private Type type;
    @XmlElementRef
    private Condition condition;
    @XmlElementRef
    private Text text;
    @XmlAnyElement(lax=true)
    private Object extension;

    private StanzaError() {
        this.condition = new UndefinedCondition();
    }

    public StanzaError(Type type, Condition condition) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null.");
        }
        this.type = type;
        this.condition = condition;
    }

    public StanzaError(Type type, Condition condition, String text) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null.");
        }
        this.type = type;
        this.condition = condition;
        this.setText(text);
    }

    public StanzaError(Condition condition) {
        this.condition = condition;
        this.type = ASSOCIATED_ERROR_TYPE.get(condition.getClass());
    }

    public StanzaError(Condition condition, String text) {
        this(condition);
        this.setText(text);
    }

    public Jid getBy() {
        return this.by;
    }

    public void setBy(Jid by) {
        this.by = by;
    }

    public Type getType() {
        return this.type;
    }

    public String getText() {
        if (this.text != null) {
            return this.text.getText();
        }
        return null;
    }

    public void setText(String text) {
        this.setText(text, null);
    }

    public void setText(String text, String language) {
        this.text = text != null ? new Text(text, language) : null;
    }

    public String getLanguage() {
        if (this.text != null) {
            return this.text.getLanguage();
        }
        return null;
    }

    public Object getExtension() {
        return this.extension;
    }

    public void setExtension(Object extension) {
        this.extension = extension;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.condition);
        sb.append("  -  (");
        sb.append((Object)this.type);
        sb.append(")");
        if (this.text != null) {
            sb.append("\n        ");
            sb.append(this.text.getText());
        }
        if (this.extension != null) {
            sb.append("\n        ");
            sb.append(this.extension);
        }
        return sb.toString();
    }

    static {
        ASSOCIATED_ERROR_TYPE.put(BadRequest.class, Type.MODIFY);
        ASSOCIATED_ERROR_TYPE.put(Conflict.class, Type.CANCEL);
        ASSOCIATED_ERROR_TYPE.put(FeatureNotImplemented.class, Type.CANCEL);
        ASSOCIATED_ERROR_TYPE.put(Forbidden.class, Type.AUTH);
        ASSOCIATED_ERROR_TYPE.put(Gone.class, Type.CANCEL);
        ASSOCIATED_ERROR_TYPE.put(InternalServerError.class, Type.CANCEL);
        ASSOCIATED_ERROR_TYPE.put(ItemNotFound.class, Type.CANCEL);
        ASSOCIATED_ERROR_TYPE.put(JidMalformed.class, Type.MODIFY);
        ASSOCIATED_ERROR_TYPE.put(NotAcceptable.class, Type.MODIFY);
        ASSOCIATED_ERROR_TYPE.put(NotAllowed.class, Type.CANCEL);
        ASSOCIATED_ERROR_TYPE.put(NotAuthorized.class, Type.AUTH);
        ASSOCIATED_ERROR_TYPE.put(PolicyViolation.class, Type.MODIFY);
        ASSOCIATED_ERROR_TYPE.put(RecipientUnavailable.class, Type.WAIT);
        ASSOCIATED_ERROR_TYPE.put(Redirect.class, Type.MODIFY);
        ASSOCIATED_ERROR_TYPE.put(RegistrationRequired.class, Type.AUTH);
        ASSOCIATED_ERROR_TYPE.put(RemoteServerNotFound.class, Type.CANCEL);
        ASSOCIATED_ERROR_TYPE.put(RemoteServerTimeout.class, Type.WAIT);
        ASSOCIATED_ERROR_TYPE.put(ResourceConstraint.class, Type.WAIT);
        ASSOCIATED_ERROR_TYPE.put(ServiceUnavailable.class, Type.CANCEL);
        ASSOCIATED_ERROR_TYPE.put(SubscriptionRequired.class, Type.AUTH);
        ASSOCIATED_ERROR_TYPE.put(UndefinedCondition.class, Type.CANCEL);
        ASSOCIATED_ERROR_TYPE.put(UnexpectedRequest.class, Type.WAIT);
    }

    @XmlEnum
    public static enum Type {
        AUTH("retry after providing credentials"),
        CANCEL("do not retry (the error cannot be remedied)"),
        CONTINUE("proceed (the condition was only a warning)"),
        MODIFY("retry after changing the data sent"),
        WAIT("retry after waiting (the error is temporary)");

        private final String errorText;

        private Type(String errorText) {
            this.errorText = errorText;
        }

        public String toString() {
            return "type '" + this.name().toLowerCase() + "': " + this.errorText;
        }
    }
}

