/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.data.validate.model;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;

@XmlRootElement(name="validate")
public final class Validation {
    @XmlAttribute(name="datatype")
    private String dataType;
    @XmlElements(value={@XmlElement(name="basic", type=ValidationMethod.Basic.class), @XmlElement(name="open", type=ValidationMethod.Open.class), @XmlElement(name="range", type=ValidationMethod.Range.class), @XmlElement(name="regex", type=ValidationMethod.Regex.class)})
    private ValidationMethod validationMethod;
    @XmlElement(name="list-range")
    private ListRange listRange;

    private Validation() {
    }

    public Validation(String dataType) {
        this.dataType = dataType;
    }

    public Validation(ValidationMethod validationMethod) {
        this.validationMethod = validationMethod;
    }

    public Validation(String dataType, ValidationMethod validationMethod) {
        this.dataType = dataType;
        this.validationMethod = validationMethod;
    }

    public Validation(String dataType, ValidationMethod validationMethod, ListRange listRange) {
        this.dataType = dataType;
        this.validationMethod = validationMethod;
        this.listRange = listRange;
    }

    public ValidationMethod getValidationMethod() {
        return this.validationMethod;
    }

    public String getDataType() {
        return this.dataType;
    }

    public ListRange getListRange() {
        return this.listRange;
    }

    public static final class ListRange {
        @XmlAttribute(name="min")
        private Integer min;
        @XmlAttribute(name="max")
        private Integer max;

        private ListRange() {
        }

        public ListRange(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public Integer getMin() {
            return this.min;
        }

        public Integer getMax() {
            return this.max;
        }
    }

    public static abstract class ValidationMethod {
        @XmlValue
        protected String value;

        private ValidationMethod() {
        }

        public static final class Regex
        extends ValidationMethod {
            private Regex() {
            }

            public Regex(String regex) {
                this.value = regex;
            }

            public String getRegex() {
                return this.value;
            }
        }

        public static final class Range
        extends ValidationMethod {
            @XmlAttribute(name="min")
            private String min;
            @XmlAttribute(name="max")
            private String max;

            private Range() {
            }

            public Range(String min, String max) {
                this.min = min;
                this.max = max;
            }

            public String getMin() {
                return this.min;
            }

            public String getMax() {
                return this.max;
            }
        }

        public static final class Open
        extends ValidationMethod {
        }

        public static final class Basic
        extends ValidationMethod {
        }
    }
}

