/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import rocks.xmpp.core.XmppUtils;

public abstract class XmlTest {
    private static final String START_STREAM = "<?xml version='1.0' encoding='UTF-8'?><stream:stream xmlns:stream=\"http://etherx.jabber.org/streams\" xmlns=\"jabber:client\" from=\"localhost\" id=\"55aa4529\" xml:lang=\"en\" version=\"1.0\">";
    private static final String END_STREAM = "</stream:stream>";
    private Unmarshaller unmarshaller;
    private Marshaller marshaller;

    protected XmlTest(Class<?> ... context) throws JAXBException, XMLStreamException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])context);
        this.unmarshaller = jaxbContext.createUnmarshaller();
        this.marshaller = jaxbContext.createMarshaller();
        this.marshaller.setProperty("jaxb.fragment", (Object)true);
    }

    private static XMLEventReader getStream(String stanza) throws XMLStreamException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        printStream.print(START_STREAM + stanza + END_STREAM);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        XMLEventReader xmlEventReader = XMLInputFactory.newFactory().createXMLEventReader(inputStream);
        xmlEventReader.nextEvent();
        xmlEventReader.nextEvent();
        return xmlEventReader;
    }

    protected <T> T unmarshal(String xml, Class<T> type) throws XMLStreamException, JAXBException {
        XMLEventReader xmlEventReader = XmlTest.getStream(xml);
        return (T)this.unmarshaller.unmarshal(xmlEventReader, type).getValue();
    }

    protected String marshal(Object object) throws XMLStreamException, JAXBException {
        StringWriter writer = new StringWriter();
        XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newFactory().createXMLStreamWriter(writer);
        XMLStreamWriter prefixFreeWriter = XmppUtils.createXmppStreamWriter((XMLStreamWriter)xmlStreamWriter, (boolean)true);
        this.marshaller.marshal(object, prefixFreeWriter);
        return ((Object)writer).toString();
    }
}

