/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core.sasl.scram;

import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.core.sasl.scram.SaslPrep;

public class SaslPrepTest {
    @Test
    public void shouldMapToSpace() {
        String s = "\u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u200b\u202f\u205f\u3000";
        Assert.assertEquals((String)SaslPrep.prepare((String)s), (String)"                 ");
    }

    @Test
    public void shouldMapToNothing() {
        String s = "\u034f\u1806\u180b\u180c\u180d\u200c\u200d\u2060\ufe00\ufe01\ufe02\ufe03\ufe04\ufe05\ufe06\ufe07\ufe08\ufe09\ufe0a\ufe0b\ufe0c\ufe0d\ufe0e\ufe0f\ufeff";
        Assert.assertEquals((String)SaslPrep.prepare((String)s), (String)"");
    }

    @Test
    public void testAsciiControlCharacters() {
        String[] chars = new String[]{"\u0000", "\u001f", "\u007f", "\ud83f\udffe"};
        int failed = 0;
        for (String aChar : chars) {
            try {
                SaslPrep.prepare((String)aChar);
            }
            catch (IllegalArgumentException e) {
                ++failed;
            }
        }
        Assert.assertEquals((int)failed, (int)chars.length);
    }

    @Test
    public void testSurrogateCodes() {
        String[] chars = new String[]{"\ud800", "\udfff"};
        int failed = 0;
        for (String aChar : chars) {
            try {
                SaslPrep.prepare((String)aChar);
            }
            catch (IllegalArgumentException e) {
                ++failed;
            }
        }
        Assert.assertEquals((int)failed, (int)chars.length);
    }

    @Test
    public void testNonAsciiControlCharacters() {
        String[] chars = new String[]{"\u0080", "\u06dd", "\u070f", "\u180e", "\u2028", "\u2029", "\u2061", "\u2062", "\u2063", "\u206a", "\u206b", "\u206c", "\u206d", "\u206e", "\u206f", "\ufff9", "\ufffa", "\ufffb", "\ud834\udd73", "\ud834\udd7a"};
        int failed = 0;
        for (String aChar : chars) {
            try {
                SaslPrep.prepare((String)aChar);
            }
            catch (IllegalArgumentException e) {
                ++failed;
            }
        }
        Assert.assertEquals((int)failed, (int)chars.length);
    }

    @Test
    public void testPrivateUseCharacters() {
        String[] chars = new String[]{"\ue000", "\uf8ff", "\udb80\udc00", "\udbc0\udc00"};
        int failed = 0;
        for (String aChar : chars) {
            try {
                SaslPrep.prepare((String)aChar);
            }
            catch (IllegalArgumentException e) {
                ++failed;
            }
        }
        Assert.assertEquals((int)failed, (int)chars.length);
    }

    @Test
    public void testNonCharacterCodePoints() {
        String[] chars = new String[]{"\ufdd0", "\ufdef"};
        int failed = 0;
        for (String aChar : chars) {
            try {
                SaslPrep.prepare((String)aChar);
            }
            catch (IllegalArgumentException e) {
                ++failed;
            }
        }
        Assert.assertEquals((int)failed, (int)chars.length);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInvalidBidiString() {
        String s = "\u06271";
        SaslPrep.prepare((String)s);
    }

    @Test
    public void testValidBidiString() {
        String s = "\u06271\u0628";
        Assert.assertEquals((String)SaslPrep.prepare((String)s), (String)"\u06271\u0628");
    }

    @Test
    public void testProhibitedChars() {
        String[] str = new String[]{"\u200e", "\u200f", "\u202a", "\u202b", "\u202c", "\u202d", "\u202e", "\u206a", "\u206b", "\u206c", "\u206d", "\u206e", "\u206f"};
        int fails = 0;
        for (String s : str) {
            try {
                SaslPrep.prepare((String)s);
            }
            catch (Exception e) {
                ++fails;
            }
        }
        Assert.assertEquals((int)fails, (int)13);
    }

    @Test
    public void testExample1() {
        String input = "I\u00adX";
        String output = SaslPrep.prepare((String)input);
        Assert.assertEquals((String)output, (String)"IX");
    }

    @Test
    public void testExample2() {
        String input = "user";
        String output = SaslPrep.prepare((String)input);
        Assert.assertEquals((String)output, (String)"user");
    }

    @Test
    public void testExample3() {
        String input = "USER";
        String output = SaslPrep.prepare((String)input);
        Assert.assertEquals((String)output, (String)"USER");
    }

    @Test
    public void testExample4() {
        String input = "\u00aa";
        String output = SaslPrep.prepare((String)input);
        Assert.assertEquals((String)output, (String)"a");
    }

    @Test
    public void testExample5() {
        String input = "\u2168";
        String output = SaslPrep.prepare((String)input);
        Assert.assertEquals((String)output, (String)"IX");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testExample6() {
        String input = "\u0007";
        SaslPrep.prepare((String)input);
        Assert.fail((String)"Should have thrown exception");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testExample7() {
        String input = "\u06271";
        SaslPrep.prepare((String)input);
        Assert.fail((String)"Should have thrown exception");
    }
}

