/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.extensions.data.validate;

import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.testng.Assert;
import org.testng.annotations.Test;
import rocks.xmpp.core.XmlTest;
import rocks.xmpp.extensions.data.model.DataForm;
import rocks.xmpp.extensions.data.validate.model.Validation;

public class DataFormsValidateTest
extends XmlTest {
    protected DataFormsValidateTest() throws JAXBException, XMLStreamException {
        super(DataForm.class, Validation.class);
    }

    @Test
    public void unmarshalDataFormWithValidateBasic() throws XMLStreamException, JAXBException {
        String xml = "<x xmlns='jabber:x:data' type='form'><field var='evt.date' type='text-single' label='Event Date/Time'>\n  <validate xmlns='http://jabber.org/protocol/xdata-validate'\n            datatype='xs:dateTime'>\n    <basic/>\n  </validate>\n  <value>2003-10-06T11:22:00-07:00</value>\n</field></x>";
        DataForm dataForm = this.unmarshal(xml, DataForm.class);
        Assert.assertNotNull((Object)dataForm);
        Validation validation = ((DataForm.Field)dataForm.getFields().get(0)).getValidation();
        Assert.assertNotNull((Object)validation);
        Assert.assertEquals((String)validation.getDataType(), (String)"xs:dateTime");
        Assert.assertTrue((boolean)(validation.getValidationMethod() instanceof Validation.ValidationMethod.Basic));
    }

    @Test
    public void unmarshalDataFormWithValidateOpen() throws XMLStreamException, JAXBException {
        String xml = "<x xmlns='jabber:x:data' type='form'><field var='evt.category' \n       type='list-single' \n       label='Event Category'>\n  <validate xmlns='http://jabber.org/protocol/xdata-validate'\n            datatype='xs:string'>\n    <open/>\n  </validate>\n  <option><value>holiday</value></option>\n  <option><value>reminder</value></option>\n  <option><value>appointment</value></option>\n</field></x>";
        DataForm dataForm = this.unmarshal(xml, DataForm.class);
        Assert.assertNotNull((Object)dataForm);
        Validation validation = ((DataForm.Field)dataForm.getFields().get(0)).getValidation();
        Assert.assertNotNull((Object)validation);
        Assert.assertEquals((String)validation.getDataType(), (String)"xs:string");
        Assert.assertTrue((boolean)(validation.getValidationMethod() instanceof Validation.ValidationMethod.Open));
    }

    @Test
    public void unmarshalDataFormWithValidateRange() throws XMLStreamException, JAXBException {
        String xml = "<x xmlns='jabber:x:data' type='form'><field var='evt.date' type='text-single' label='Event Date/Time'>\n  <validate xmlns='http://jabber.org/protocol/xdata-validate'\n            datatype='xs:dateTime'>\n    <range min='2003-10-05T00:00:00-07:00' \n           max='2003-10-24T23:59:59-07:00'/>\n  </validate>\n  <value>2003-10-06T11:22:00-07:00</value>\n</field></x>";
        DataForm dataForm = this.unmarshal(xml, DataForm.class);
        Assert.assertNotNull((Object)dataForm);
        Validation validation = ((DataForm.Field)dataForm.getFields().get(0)).getValidation();
        Assert.assertNotNull((Object)validation);
        Assert.assertEquals((String)validation.getDataType(), (String)"xs:dateTime");
        Assert.assertTrue((boolean)(validation.getValidationMethod() instanceof Validation.ValidationMethod.Range));
        Assert.assertEquals((String)((Validation.ValidationMethod.Range)validation.getValidationMethod()).getMin(), (String)"2003-10-05T00:00:00-07:00");
        Assert.assertEquals((String)((Validation.ValidationMethod.Range)validation.getValidationMethod()).getMax(), (String)"2003-10-24T23:59:59-07:00");
    }

    @Test
    public void unmarshalDataFormWithValidateRegex() throws XMLStreamException, JAXBException {
        String xml = "<x xmlns='jabber:x:data' type='form'><field var='ssn' type='text-single' label='Social Security Number'>\n  <desc>This field should be your SSN, including '-' (e.g. 123-12-1234)</desc>\n  <validate xmlns='http://jabber.org/protocol/xdata-validate'\n            datatype='xs:string'>\n    <regex>([0-9]{3})-([0-9]{2})-([0-9]{4})</regex>\n  </validate>\n</field>\n</x>";
        DataForm dataForm = this.unmarshal(xml, DataForm.class);
        Assert.assertNotNull((Object)dataForm);
        Validation validation = ((DataForm.Field)dataForm.getFields().get(0)).getValidation();
        Assert.assertNotNull((Object)validation);
        Assert.assertEquals((String)validation.getDataType(), (String)"xs:string");
        Assert.assertTrue((boolean)(validation.getValidationMethod() instanceof Validation.ValidationMethod.Regex));
        Assert.assertEquals((String)((Validation.ValidationMethod.Regex)validation.getValidationMethod()).getRegex(), (String)"([0-9]{3})-([0-9]{2})-([0-9]{4})");
    }

    @Test
    public void unmarshalDataFormWithValidateListRange() throws XMLStreamException, JAXBException {
        String xml = "<x xmlns='jabber:x:data' type='form'><field var='evt.notify-methods' \n       type='list-multi' \n       label='Notify me by'>\n  <validate xmlns='http://jabber.org/protocol/xdata-validate'\n            datatype='xs:string'>\n    <basic/>\n    <list-range min='1' max='3'/>\n  </validate>\n  <option><value>e-mail</value></option>\n  <option><value>jabber/xmpp</value></option>\n  <option><value>work phone</value></option>\n  <option><value>home phone</value></option>\n  <option><value>cell phone</value></option>\n</field>\n</x>";
        DataForm dataForm = this.unmarshal(xml, DataForm.class);
        Assert.assertNotNull((Object)dataForm);
        Validation validation = ((DataForm.Field)dataForm.getFields().get(0)).getValidation();
        Assert.assertNotNull((Object)validation);
        Assert.assertEquals((String)validation.getDataType(), (String)"xs:string");
        Assert.assertTrue((boolean)(validation.getValidationMethod() instanceof Validation.ValidationMethod.Basic));
        Assert.assertNotNull((Object)validation.getListRange());
        Assert.assertEquals((Object)validation.getListRange().getMin(), (Object)1);
        Assert.assertEquals((Object)validation.getListRange().getMax(), (Object)3);
    }
}

