/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core;

import java.io.Serializable;
import java.text.Bidi;
import java.text.Normalizer;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Jid
implements Comparable<Jid>,
Serializable,
CharSequence {
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("[ \"&'/:<>@]|\\\\(?=20|22|26|27|2f|3a|3c|3e|40|5c)");
    private static final Pattern UNESCAPE_PATTERN = Pattern.compile("\\\\(20|22|26|27|2f|3a|3c|3e|40|5c)");
    private static final Pattern PROHIBITED_CHARACTERS = Pattern.compile("[^\\p{L}\\p{N}\\p{P}\\p{S}\\p{M}\\s]|[\u0340\u0341]");
    private static final String DOMAIN_PART = "((?:(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9]))+)";
    private static final Pattern JID = Pattern.compile("^((.*?)@)?((?:(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9]))+)(/(.*))?$");
    private static final Pattern MAP_TO_NOTHING = Pattern.compile("([\u00ad\u034f\u1806\u180b-\u180d\u200b-\u200d\u2060\ufe00-\ufe0f\ufeff])");
    private static final LruCache<String, Jid> ESCAPED_CACHE = new LruCache(5000);
    private static final LruCache<String, Jid> UNESCAPED_CACHE = new LruCache(5000);
    private static final long serialVersionUID = -3824234106101731424L;
    private final String escapedLocal;
    private final String local;
    private final String domain;
    private final String resource;

    public Jid(String domain) {
        this(null, domain, null);
    }

    public Jid(String local, String domain) {
        this(local, domain, null);
    }

    public Jid(String local, String domain, String resource) {
        this(local, domain, resource, false, true);
    }

    private Jid(String local, String domain, String resource, boolean doUnescape, boolean prepareAndValidate) {
        String preparedNode;
        if (prepareAndValidate) {
            preparedNode = Jid.prepare(local, true);
            this.validateDomain(domain);
            this.validateLength(preparedNode, "local");
        } else {
            preparedNode = local;
        }
        String preparedResource = Jid.prepare(resource, false);
        this.validateLength(preparedResource, "resource");
        this.local = doUnescape ? Jid.unescape(preparedNode) : preparedNode;
        this.escapedLocal = Jid.escape(this.local);
        this.domain = domain.toLowerCase();
        this.resource = preparedResource;
    }

    public static Jid valueOf(String jid) {
        return Jid.valueOf(jid, false);
    }

    public static Jid valueOf(String jid, boolean doUnescape) {
        if (jid == null) {
            throw new IllegalArgumentException("jid must not be null.");
        }
        if ((jid = jid.trim()).isEmpty()) {
            throw new IllegalArgumentException("jid must not be empty.");
        }
        Jid result = doUnescape ? (Jid)((LruCache)Jid.UNESCAPED_CACHE).get(jid) : (Jid)((LruCache)Jid.ESCAPED_CACHE).get(jid);
        if (result != null) {
            return result;
        }
        Matcher matcher = JID.matcher(jid);
        if (matcher.matches()) {
            Jid jidValue = new Jid(matcher.group(2), matcher.group(3), matcher.group(8), doUnescape, true);
            if (doUnescape) {
                ((LruCache)Jid.UNESCAPED_CACHE).put(jid, jidValue);
            } else {
                ((LruCache)Jid.ESCAPED_CACHE).put(jid, jidValue);
            }
            return jidValue;
        }
        throw new IllegalArgumentException("Could not parse JID.");
    }

    private static String escape(String jid) {
        if (jid != null) {
            Matcher matcher = ESCAPE_PATTERN.matcher(jid);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                String match = matcher.group();
                matcher.appendReplacement(sb, String.format("\\\\%x", match.getBytes()[0]));
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
        return null;
    }

    private static String unescape(String jid) {
        if (jid != null) {
            Matcher matcher = UNESCAPE_PATTERN.matcher(jid);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                String match = matcher.group(1);
                int num = Integer.parseInt(match, 16);
                String value = String.valueOf((char)num);
                if (value.equals("\\")) {
                    matcher.appendReplacement(sb, "\\\\");
                    continue;
                }
                matcher.appendReplacement(sb, value);
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
        return null;
    }

    static String prepare(String input, boolean isLocalPart) {
        if (input != null) {
            Bidi bidi;
            Matcher matcher;
            String prepared = MAP_TO_NOTHING.matcher(input).replaceAll("");
            if (isLocalPart) {
                prepared = prepared.toUpperCase(Locale.ENGLISH).toLowerCase(Locale.ENGLISH);
            }
            prepared = Normalizer.normalize(prepared, Normalizer.Form.NFKC);
            if (isLocalPart) {
                prepared = prepared.toLowerCase(Locale.ENGLISH);
            }
            if ((matcher = PROHIBITED_CHARACTERS.matcher(prepared)).find()) {
                throw new IllegalArgumentException("Local or resource part contains prohibited characters.");
            }
            if (Bidi.requiresBidi(prepared.toCharArray(), 0, prepared.length()) && (bidi = new Bidi(input, 0)).isMixed() && (bidi.getLevelAt(0) != 1 || bidi.getLevelAt(0) != bidi.getLevelAt(input.length() - 1))) {
                throw new IllegalArgumentException("Local or resource part contains mixed bidirectional characters.");
            }
            return prepared;
        }
        return null;
    }

    private void validateDomain(String domain) {
        if (domain == null) {
            throw new IllegalArgumentException("domain must not be null.");
        }
        if (domain.contains("@")) {
            throw new IllegalArgumentException("domain must not contain a '@' sign");
        }
        this.validateLength(domain, "domain");
    }

    private void validateLength(String value, String part) {
        if (value != null) {
            if (value.isEmpty()) {
                throw new IllegalArgumentException(String.format("%s must not be empty.", part));
            }
            if (value.length() > 1023) {
                throw new IllegalArgumentException(String.format("%s must not be greater than 1023 characters.", part));
            }
        }
    }

    public boolean isFullJid() {
        return this.resource != null;
    }

    public boolean isBareJid() {
        return this.resource == null;
    }

    public Jid asBareJid() {
        return new Jid(this.local, this.domain, null, false, false);
    }

    public Jid withResource(String resource) {
        return new Jid(this.local, this.domain, resource, false, true);
    }

    public String getLocal() {
        return this.local;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getResource() {
        return this.resource;
    }

    public String toEscapedString() {
        return this.toString(this.escapedLocal, this.domain, this.resource);
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.toString(this.local, this.domain, this.resource);
    }

    private String toString(String local, String domain, String resource) {
        StringBuilder sb = new StringBuilder();
        if (local != null) {
            sb.append(local);
            sb.append("@");
        }
        sb.append(domain);
        if (resource != null) {
            sb.append("/");
            sb.append(resource);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Jid)) {
            return false;
        }
        Jid other = (Jid)o;
        return (this.local == null ? other.local == null : this.local.equals(other.local)) && (this.domain == null ? other.domain == null : this.domain.equals(other.domain)) && (this.resource == null ? other.resource == null : this.resource.equals(other.resource));
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.local == null ? 0 : this.local.hashCode());
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        return result;
    }

    @Override
    public int compareTo(Jid o) {
        if (this == o) {
            return 0;
        }
        if (o != null) {
            int result = this.domain != null ? (o.domain != null ? this.domain.compareTo(o.domain) : -1) : (o.domain != null ? 1 : 0);
            if (result == 0) {
                result = this.local != null ? (o.local != null ? this.local.compareTo(o.local) : 1) : (o.local != null ? -1 : 0);
            }
            if (result == 0) {
                result = this.resource != null ? (o.resource != null ? this.resource.compareTo(o.resource) : 1) : (o.resource != null ? -1 : 0);
            }
            return result;
        }
        return -1;
    }

    private static final class LruCache<K, V> {
        private final int maxEntries;
        private final ConcurrentHashMap<K, V> map;
        private final ConcurrentLinkedQueue<K> queue;

        private LruCache(int maxEntries) {
            this.maxEntries = maxEntries;
            this.map = new ConcurrentHashMap(maxEntries);
            this.queue = new ConcurrentLinkedQueue();
        }

        private void put(K key, V value) {
            if (this.map.put(key, value) != null) {
                if (this.queue.remove(key)) {
                    this.queue.offer(key);
                }
            } else {
                this.queue.offer(key);
            }
            while (this.queue.size() > this.maxEntries) {
                K oldestKey = this.queue.poll();
                if (null == oldestKey) continue;
                this.map.remove(oldestKey);
            }
        }

        private V get(K key) {
            if (this.queue.remove(key)) {
                this.queue.offer(key);
            }
            return this.map.get(key);
        }
    }
}

