/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

final class PrefixFreeCanonicalizationWriter
implements XMLStreamWriter {
    private final XMLStreamWriter xsw;
    private final ContentNamespaceContext nc;

    public PrefixFreeCanonicalizationWriter(XMLStreamWriter xsw, String contentNamespace) throws XMLStreamException {
        this.xsw = xsw;
        this.nc = new ContentNamespaceContext(contentNamespace);
        xsw.setNamespaceContext(this.nc);
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.nc.pushNamespaceUri("");
        this.xsw.writeStartElement(localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.nc.pushNamespaceUri(namespaceURI);
        this.xsw.writeStartElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.nc.pushNamespaceUri(namespaceURI);
        if (this.nc.shouldWriteNamespacePrefix()) {
            this.xsw.writeStartElement(prefix, localName, namespaceURI);
        } else {
            this.xsw.writeStartElement(namespaceURI, localName);
            this.writeDefaultNamespaceIfNecessary(namespaceURI);
        }
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.nc.pushNamespaceUri(namespaceURI);
        this.nc.currentNamespaceUris.clear();
        this.xsw.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.nc.pushNamespaceUri(namespaceURI);
        if (this.nc.shouldWriteNamespacePrefix()) {
            this.xsw.writeEmptyElement(prefix, localName, namespaceURI);
        } else {
            this.xsw.writeEmptyElement(namespaceURI, localName);
            this.writeDefaultNamespaceIfNecessary(namespaceURI);
        }
    }

    private void writeDefaultNamespaceIfNecessary(String namespaceURI) throws XMLStreamException {
        String currentDefaultNS;
        if (namespaceURI != null && namespaceURI.length() > 0 && !namespaceURI.equals(currentDefaultNS = this.nc.getNamespaceURI(""))) {
            this.writeDefaultNamespace(namespaceURI);
            this.nc.setDefaultNS(namespaceURI);
        }
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.xsw.writeEmptyElement(localName);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.xsw.writeEndElement();
        this.nc.popNamespaceUri();
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.xsw.writeEndDocument();
    }

    @Override
    public void close() throws XMLStreamException {
        this.xsw.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.xsw.flush();
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.xsw.writeAttribute(localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        if (!this.nc.currentNamespaceUris.contains(namespaceURI)) {
            this.xsw.writeNamespace(prefix, namespaceURI);
            this.nc.currentNamespaceUris.add(namespaceURI);
        }
        this.xsw.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.xsw.writeAttribute(namespaceURI, localName, value);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        if (this.nc.shouldWriteNamespacePrefix()) {
            this.xsw.writeNamespace(prefix, namespaceURI);
        }
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.xsw.writeDefaultNamespace(namespaceURI);
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.xsw.writeComment(data);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.xsw.writeProcessingInstruction(target);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.xsw.writeProcessingInstruction(target, data);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.xsw.writeCData(data);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.xsw.writeDTD(dtd);
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.xsw.writeEntityRef(name);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.xsw.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.xsw.writeStartDocument(version);
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.xsw.writeStartDocument(encoding, version);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.xsw.writeCharacters(text);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.xsw.writeCharacters(text, start, len);
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.xsw.getPrefix(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.xsw.setPrefix(prefix, uri);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.xsw.setDefaultNamespace(uri);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.xsw.getNamespaceContext();
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.xsw.setNamespaceContext(context);
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.xsw.getProperty(name);
    }

    private static class ContentNamespaceContext
    implements NamespaceContext {
        private static final Collection<String> PREFIXED_NAMESPACES = new ArrayList<String>(Arrays.asList("http://schemas.xmlsoap.org/soap/envelope/", "http://www.w3.org/2003/05/soap-envelope"));
        private final String contentNamespace;
        private final Set<String> currentNamespaceUris = new HashSet<String>();
        private final Stack<String> namespaces = new Stack();
        private String defaultNS;

        private ContentNamespaceContext(String contentNamespace) {
            this.defaultNS = contentNamespace;
            this.contentNamespace = contentNamespace;
        }

        private void setDefaultNS(String ns) {
            this.defaultNS = ns;
        }

        private void pushNamespaceUri(String namespaceUri) {
            this.namespaces.push(namespaceUri);
            this.currentNamespaceUris.clear();
        }

        private void popNamespaceUri() {
            this.namespaces.pop();
            this.defaultNS = !this.namespaces.empty() ? this.namespaces.peek() : this.contentNamespace;
        }

        private boolean shouldWriteNamespacePrefix() {
            return !Collections.disjoint(this.namespaces, PREFIXED_NAMESPACES);
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix == null) {
                throw new IllegalArgumentException("prefix must not be null.");
            }
            if ("".equals(prefix)) {
                return this.defaultNS;
            }
            return "";
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return "";
        }

        public Iterator getPrefixes(String namespaceURI) {
            return null;
        }
    }
}

